/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.lucene.ui;

import javax.inject.Inject;
import org.eobjects.analyzer.beans.api.Renderer;
import org.eobjects.analyzer.beans.api.RendererBean;
import org.eobjects.analyzer.beans.api.RendererPrecedence;
import org.eobjects.analyzer.configuration.AnalyzerBeansConfiguration;
import org.eobjects.analyzer.job.builder.TransformerJobBuilder;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.guice.InjectorBuilder;
import org.eobjects.datacleaner.lucene.LuceneTransformer;
import org.eobjects.datacleaner.lucene.SearchIndexCatalog;
import org.eobjects.datacleaner.lucene.ui.LuceneTransformerJobBuilderPanel;
import org.eobjects.datacleaner.lucene.ui.SearchIndexCatalogFactory;
import org.eobjects.datacleaner.panels.ComponentJobBuilderRenderingFormat;
import org.eobjects.datacleaner.panels.TransformerJobBuilderPresenter;
import org.eobjects.datacleaner.user.UserPreferences;
import org.eobjects.datacleaner.widgets.properties.PropertyWidgetFactory;

@RendererBean(value=ComponentJobBuilderRenderingFormat.class)
public class LuceneTransformerJobBuilderRenderer
implements Renderer<TransformerJobBuilder<LuceneTransformer<?>>, TransformerJobBuilderPresenter> {
    @Inject
    InjectorBuilder injectorBuilder;
    @Inject
    WindowContext windowContext;
    @Inject
    UserPreferences userPreferences;
    @Inject
    AnalyzerBeansConfiguration configuration;

    public RendererPrecedence getPrecedence(TransformerJobBuilder<LuceneTransformer<?>> tjb) {
        return RendererPrecedence.HIGH;
    }

    public TransformerJobBuilderPresenter render(TransformerJobBuilder<LuceneTransformer<?>> tjb) {
        SearchIndexCatalog catalog = SearchIndexCatalogFactory.getInstance(this.userPreferences);
        PropertyWidgetFactory propertyWidgetFactory = (PropertyWidgetFactory)this.injectorBuilder.with(PropertyWidgetFactory.TYPELITERAL_BEAN_JOB_BUILDER, tjb).getInstance(PropertyWidgetFactory.class);
        return new LuceneTransformerJobBuilderPanel(tjb, propertyWidgetFactory, catalog, this.windowContext, this.configuration, this.userPreferences);
    }
}

