/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.lucene.ui;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.eobjects.analyzer.configuration.AnalyzerBeansConfiguration;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.descriptors.TransformerBeanDescriptor;
import org.eobjects.analyzer.job.builder.AbstractBeanJobBuilder;
import org.eobjects.analyzer.job.builder.TransformerJobBuilder;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.lucene.LuceneTransformer;
import org.eobjects.datacleaner.lucene.SearchIndex;
import org.eobjects.datacleaner.lucene.SearchIndexCatalog;
import org.eobjects.datacleaner.lucene.ui.Images;
import org.eobjects.datacleaner.lucene.ui.MultipleSearchIndicesPropertyWidget;
import org.eobjects.datacleaner.lucene.ui.SingleSearchIndexPropertyWidget;
import org.eobjects.datacleaner.panels.TransformerJobBuilderPanel;
import org.eobjects.datacleaner.user.UserPreferences;
import org.eobjects.datacleaner.widgets.properties.AbstractPropertyWidget;
import org.eobjects.datacleaner.widgets.properties.PropertyWidget;
import org.eobjects.datacleaner.widgets.properties.PropertyWidgetFactory;

public class LuceneTransformerJobBuilderPanel
extends TransformerJobBuilderPanel {
    private static final long serialVersionUID = 1L;
    private final Map<ConfiguredPropertyDescriptor, PropertyWidget<?>> _propertyWidgets = new IdentityHashMap();

    public LuceneTransformerJobBuilderPanel(TransformerJobBuilder<LuceneTransformer<?>> tjb, PropertyWidgetFactory propertyWidgetFactory, SearchIndexCatalog catalog, WindowContext windowContext, AnalyzerBeansConfiguration configuration, UserPreferences userPreferences) {
        super(Images.WATERMARK_IMAGE, 95, 95, tjb, windowContext, propertyWidgetFactory, configuration);
        Set searchIndexProperties = ((TransformerBeanDescriptor)tjb.getDescriptor()).getConfiguredPropertiesByType(SearchIndex.class, true);
        for (ConfiguredPropertyDescriptor property : searchIndexProperties) {
            AbstractPropertyWidget widget = property.isArray() ? new MultipleSearchIndicesPropertyWidget((AbstractBeanJobBuilder<?, ?, ?>)tjb, property, catalog) : new SingleSearchIndexPropertyWidget((AbstractBeanJobBuilder<?, ?, ?>)tjb, property, catalog, windowContext, userPreferences);
            this._propertyWidgets.put(property, (PropertyWidget<?>)widget);
        }
    }

    protected PropertyWidget<?> createPropertyWidget(AbstractBeanJobBuilder<?, ?, ?> beanJobBuilder, ConfiguredPropertyDescriptor propertyDescriptor) {
        PropertyWidget<?> widget = this._propertyWidgets.get(propertyDescriptor);
        if (widget != null) {
            return widget;
        }
        return super.createPropertyWidget(beanJobBuilder, propertyDescriptor);
    }
}

