/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.lucene;

import java.util.concurrent.atomic.AtomicInteger;
import org.eobjects.analyzer.beans.api.Analyzer;
import org.eobjects.analyzer.beans.api.AnalyzerBean;
import org.eobjects.analyzer.beans.api.Categorized;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Convertable;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.Initialize;
import org.eobjects.analyzer.beans.writers.WriteBuffer;
import org.eobjects.analyzer.beans.writers.WriteBufferSizeOption;
import org.eobjects.analyzer.beans.writers.WriteDataCategory;
import org.eobjects.analyzer.beans.writers.WriteDataResult;
import org.eobjects.analyzer.beans.writers.WriteDataResultImpl;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.datacleaner.lucene.SearchIndex;
import org.eobjects.datacleaner.lucene.SearchIndexConverter;
import org.eobjects.datacleaner.lucene.WriteSearchIndexAction;
import org.eobjects.metamodel.util.Action;

@AnalyzerBean(value="Write to Lucene index")
@Description(value="Writes data to a Lucene index, making it searchable at a later stage.")
@Categorized(value={WriteDataCategory.class})
public class WriteSearchIndexAnalyzer
implements Analyzer<WriteDataResult> {
    @Configured(order=1, value="Value(s) and field name(s) in index")
    InputColumn<String>[] values;
    @Configured(order=2)
    String[] searchFields;
    @Configured(order=10)
    @Convertable(value=SearchIndexConverter.class)
    @Description(value="Search index to write to.")
    SearchIndex searchIndex;
    @Configured(order=20)
    @Description(value="How much data to buffer before committing batches of data. Large batches often perform better, but require more memory.")
    WriteBufferSizeOption bufferSize = WriteBufferSizeOption.LARGE;
    private WriteBuffer _writeBuffer;
    private AtomicInteger _counter;

    @Initialize
    public void init() {
        int numColumns = this.searchFields.length;
        this._writeBuffer = new WriteBuffer(this.bufferSize.calculateBufferSize(numColumns), (Action)new WriteSearchIndexAction(this.searchIndex, this.searchFields));
        this._counter = new AtomicInteger();
    }

    public void run(InputRow row, int distinctCount) {
        Object[] rowData = new Object[this.searchFields.length];
        for (int i = 0; i < this.searchFields.length; ++i) {
            String value = (String)row.getValue(this.values[i]);
            rowData[i] = value;
        }
        this._writeBuffer.addToBuffer(rowData);
        this._counter.incrementAndGet();
    }

    public WriteDataResult getResult() {
        this._writeBuffer.flushBuffer();
        return new WriteDataResultImpl(this._counter.get(), (Datastore)null, "SearchIndex", this.searchIndex.getName());
    }
}

