/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.lucene;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.eobjects.analyzer.beans.api.Categorized;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Convertable;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.Initialize;
import org.eobjects.analyzer.beans.api.OutputColumns;
import org.eobjects.analyzer.beans.api.TransformerBean;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.datacleaner.lucene.LuceneSearchCategory;
import org.eobjects.datacleaner.lucene.LuceneTransformer;
import org.eobjects.datacleaner.lucene.SearchHelper;
import org.eobjects.datacleaner.lucene.SearchIndex;
import org.eobjects.datacleaner.lucene.SearchIndexConverter;

@TransformerBean(value="Search Lucene index (return map)")
@Description(value="Searches a Lucene search index and returns the top result, if any. This transformer returns the search result as a map, which can then be post-processed eg. using the 'data structures' transformation options.")
@Categorized(value={LuceneSearchCategory.class})
public class SearchToMapTransformer
implements LuceneTransformer<Object> {
    @Configured
    @Description(value="Column containing search term(s) to fire.")
    InputColumn<String> searchInput;
    @Configured
    @Convertable(value=SearchIndexConverter.class)
    @Description(value="Search index to fire searches on.")
    SearchIndex searchIndex;
    private IndexSearcher indexSearcher;

    public OutputColumns getOutputColumns() {
        String[] columnNames = new String[]{"Search result", "Score"};
        Class[] columnTypes = new Class[]{Map.class, Number.class};
        return new OutputColumns(columnNames, columnTypes);
    }

    @Initialize
    public void init() {
        this.indexSearcher = this.searchIndex.getSearcher();
    }

    public Object[] transform(InputRow row) {
        Document document;
        Object[] result = new Object[2];
        result[1] = 0;
        String searchText = (String)row.getValue(this.searchInput);
        TopDocs searchResult = SearchHelper.search(this.indexSearcher, searchText);
        if (searchResult == null) {
            result[1] = -1;
            return result;
        }
        if (searchResult.totalHits == 0) {
            return result;
        }
        ScoreDoc scoreDoc = searchResult.scoreDocs[0];
        try {
            document = this.indexSearcher.doc(scoreDoc.doc);
        }
        catch (Exception e) {
            throw new IllegalStateException("Fetching document from index threw exception", e);
        }
        result[0] = SearchToMapTransformer.toMap(document);
        result[1] = Float.valueOf(scoreDoc.score);
        return result;
    }

    protected static Map<String, String> toMap(Document document) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        List fields = document.getFields();
        for (IndexableField field : fields) {
            String name = field.name();
            String value = document.get(name);
            result.put(name, value);
        }
        return result;
    }
}

