/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.lucene;

import java.util.StringTokenizer;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.TopDocs;
import org.eobjects.analyzer.beans.api.Categorized;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Convertable;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.Initialize;
import org.eobjects.analyzer.beans.api.OutputColumns;
import org.eobjects.analyzer.beans.api.TransformerBean;
import org.eobjects.analyzer.beans.categories.MatchingAndStandardizationCategory;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.datacleaner.lucene.LuceneSearchCategory;
import org.eobjects.datacleaner.lucene.LuceneTransformer;
import org.eobjects.datacleaner.lucene.SearchHelper;
import org.eobjects.datacleaner.lucene.SearchIndex;
import org.eobjects.datacleaner.lucene.SearchIndexConverter;

@TransformerBean(value="Search index matcher")
@Description(value="Finds the best search index match for the search input using multiple search indices and marks the output with the best scoring index name.")
@Categorized(value={LuceneSearchCategory.class, MatchingAndStandardizationCategory.class})
public class SearchIndexMatcherTransformer
implements LuceneTransformer<String> {
    private static final char[] DELIMITERS = new char[]{' ', '\t', '\n', '\r', '\f', ',', ';', ':', '-'};
    @Configured
    @Description(value="Column(s) containing search term(s).")
    InputColumn<String>[] searchInputs;
    @Configured
    @Convertable(value=SearchIndexConverter.class)
    @Description(value="Search indices to fire searches on.")
    SearchIndex[] searchIndices;
    @Configured
    boolean tokenizeInput = true;
    private IndexSearcher[] indexSearchers;

    public OutputColumns getOutputColumns() {
        String[] columnNames = new String[this.searchInputs.length];
        for (int i = 0; i < columnNames.length; ++i) {
            columnNames[i] = this.tokenizeInput ? this.searchInputs[i].getName() + " (matches)" : this.searchInputs[i].getName() + " (match)";
        }
        return new OutputColumns(columnNames);
    }

    @Initialize
    public void init() {
        this.indexSearchers = new IndexSearcher[this.searchIndices.length];
        for (int i = 0; i < this.searchIndices.length; ++i) {
            this.indexSearchers[i] = this.searchIndices[i].getSearcher();
        }
    }

    public String[] transform(InputRow row) {
        String[] result = new String[this.searchInputs.length];
        for (int i = 0; i < this.searchInputs.length; ++i) {
            String value = (String)row.getValue(this.searchInputs[i]);
            if (value == null) {
                result[i] = null;
                continue;
            }
            if (this.tokenizeInput) {
                StringBuilder sb = new StringBuilder();
                StringTokenizer st = new StringTokenizer(value, new String(DELIMITERS), true);
                while (i < result.length && st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (this.isDelimitor(token)) {
                        sb.append(token);
                        continue;
                    }
                    sb.append(this.getBestIndexName(token));
                }
                result[i] = sb.toString();
                continue;
            }
            result[i] = this.getBestIndexName(value);
        }
        return result;
    }

    private boolean isDelimitor(String token) {
        for (int i = 0; i < DELIMITERS.length; ++i) {
            if (token.indexOf(DELIMITERS[i]) == -1) continue;
            return true;
        }
        return false;
    }

    private String getBestIndexName(String searchInput) {
        String bestIndexName = null;
        float maxScore = -1.0f;
        for (int i = 0; i < this.indexSearchers.length; ++i) {
            float score;
            TopDocs result = SearchHelper.search(this.indexSearchers[i], searchInput);
            if (result == null || !((score = result.getMaxScore()) > maxScore)) continue;
            bestIndexName = this.searchIndices[i].getName();
            maxScore = score;
        }
        if (bestIndexName == null) {
            return "<?>";
        }
        return "<" + bestIndexName + ">";
    }
}

