/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.lucene;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.NIOFSDirectory;
import org.eobjects.datacleaner.lucene.AbstractSearchIndex;

public class FileSystemSearchIndex
extends AbstractSearchIndex {
    private static final long serialVersionUID = 1L;
    private final Directory _directory;
    private final File _file;

    public FileSystemSearchIndex(String name, File directory) {
        super(name);
        this._file = directory;
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("File argument must be a directory");
        }
        try {
            this._directory = new NIOFSDirectory(directory);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to construct Lucene directory", e);
        }
    }

    public File getFile() {
        return this._file;
    }

    @Override
    protected Directory getDirectory() {
        return this._directory;
    }
}

