/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.SimpleAnalyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.eobjects.analyzer.reference.AbstractReferenceData;
import org.eobjects.datacleaner.lucene.Constants;
import org.eobjects.datacleaner.lucene.SearchIndex;
import org.eobjects.metamodel.util.Action;

public abstract class AbstractSearchIndex
extends AbstractReferenceData
implements SearchIndex {
    private static final long serialVersionUID = 1L;

    public AbstractSearchIndex(String name) {
        super(name);
        ClassLoader classLoader = this.getClass().getClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        Codec.reloadCodecs((ClassLoader)this.getClass().getClassLoader());
    }

    protected abstract Directory getDirectory();

    @Override
    public List<String> getFieldNames() {
        try {
            ArrayList<String> fieldNames = new ArrayList<String>();
            DirectoryReader reader = this.getIndexReader();
            for (int i = 0; i < reader.maxDoc(); ++i) {
                List fields;
                Document doc = reader.document(i);
                if (doc == null || (fields = doc.getFields()) == null || fields.isEmpty()) continue;
                for (IndexableField indexableField : fields) {
                    fieldNames.add(indexableField.name());
                }
                return fieldNames;
            }
            return fieldNames;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    protected final DirectoryReader getIndexReader() {
        try {
            DirectoryReader reader = DirectoryReader.open((Directory)this.getDirectory());
            return reader;
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read from directory", e);
        }
    }

    @Override
    public IndexSearcher getSearcher() {
        DirectoryReader reader = this.getIndexReader();
        return new IndexSearcher((IndexReader)reader);
    }

    @Override
    public void write(Action<IndexWriter> writerAction) {
        try {
            SimpleAnalyzer analyzer = new SimpleAnalyzer(Constants.VERSION);
            IndexWriterConfig conf = new IndexWriterConfig(Constants.VERSION, (Analyzer)analyzer);
            Directory directory = this.getDirectory();
            IndexWriter writer = new IndexWriter(directory, conf);
            try {
                writerAction.run((Object)writer);
                writer.commit();
            }
            catch (Throwable e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new IllegalStateException("Write action threw exception", e);
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not write to directory", e);
        }
    }
}

