/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.spark.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaSparkContext;
import org.datacleaner.spark.SparkJobContext;
import org.datacleaner.util.FileFilters;

public class ResultFilePathUtils {
    private static final Logger logger = Logger.getLogger(ResultFilePathUtils.class);
    private static final String DEFAULT_RESULT_PATH = "/datacleaner/results";
    private static final String RESULT_FILE_EXTENSION = FileFilters.ANALYSIS_RESULT_SER.getExtension();

    public static String getResultFilePath(JavaSparkContext sparkContext, SparkJobContext sparkJobContext) throws URISyntaxException {
        String resultPath = sparkJobContext.getResultPath();
        Configuration hadoopConfiguration = sparkContext.hadoopConfiguration();
        String fileSystemPrefix = hadoopConfiguration.get("fs.defaultFS");
        if (resultPath == null || resultPath.isEmpty()) {
            resultPath = ResultFilePathUtils.createPath(fileSystemPrefix, DEFAULT_RESULT_PATH);
        } else {
            URI uri = URI.create(resultPath);
            if (!uri.isAbsolute()) {
                resultPath = ResultFilePathUtils.createPath(fileSystemPrefix, resultPath);
            }
        }
        resultPath = ResultFilePathUtils.attachResultJobFilename(sparkJobContext, resultPath);
        return resultPath;
    }

    private static String attachResultJobFilename(SparkJobContext sparkJobContext, String resultPath) throws URISyntaxException {
        if (resultPath != null && !resultPath.endsWith(RESULT_FILE_EXTENSION)) {
            String analysisJobXmlName = sparkJobContext.getAnalysisJobName();
            Date date = new Date();
            String filename = analysisJobXmlName + "-" + date.getTime() + RESULT_FILE_EXTENSION;
            resultPath = ResultFilePathUtils.createPath(resultPath, filename);
        }
        return resultPath;
    }

    public static String createPath(String fileSystemPrefix, String resultPath) throws URISyntaxException {
        try {
            URI systemPrefix = new URI(fileSystemPrefix);
            if (!resultPath.startsWith("/")) {
                resultPath = "/" + resultPath;
            }
            URI uri = new URI("hdfs", null, systemPrefix.getHost(), systemPrefix.getPort(), systemPrefix.getPath() + resultPath, null, null);
            return uri.toString();
        }
        catch (URISyntaxException e) {
            logger.error((Object)"Error while trying to create url for saving the job", (Throwable)e);
            throw e;
        }
    }
}

