/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.spark.functions;

import java.util.List;
import org.apache.spark.api.java.function.Function;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.data.MockInputRow;
import org.datacleaner.spark.SparkJobContext;
import scala.Tuple2;

public class ValuesToInputRowFunction
implements Function<Tuple2<Object[], Long>, InputRow> {
    private static final long serialVersionUID = 1L;
    private final SparkJobContext _sparkJobContext;

    public ValuesToInputRowFunction(SparkJobContext sparkJobContext) {
        this._sparkJobContext = sparkJobContext;
    }

    public InputRow call(Tuple2<Object[], Long> tuple) throws Exception {
        Object[] values = (Object[])tuple._1;
        Long rowNumber = (Long)tuple._2;
        MockInputRow inputRow = new MockInputRow(rowNumber.intValue());
        List sourceColumns = this._sparkJobContext.getAnalysisJob().getSourceColumns();
        for (InputColumn sourceColumn : sourceColumns) {
            assert (sourceColumn.isPhysicalColumn());
            int columnIndex = sourceColumn.getPhysicalColumn().getColumnNumber();
            Object value = values[columnIndex];
            inputRow.put(sourceColumn, value);
        }
        return inputRow;
    }
}

