/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.spark.functions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.metamodel.schema.Column;
import org.apache.spark.api.java.function.Function;
import org.datacleaner.connection.DatastoreConnection;
import org.datacleaner.connection.JsonDatastore;

public class JsonParserFunction
implements Function<String, Object[]> {
    private static final long serialVersionUID = 1L;
    private final JsonDatastore _jsonDatastore;
    private Column[] _columns;

    public JsonParserFunction(JsonDatastore jsonDatastore) {
        this._jsonDatastore = jsonDatastore;
    }

    public Object[] call(String line) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode readTree = mapper.readTree(line);
        Object[] values = this.getValues(readTree);
        return values;
    }

    private Object[] getValues(JsonNode readTree) {
        Column[] columns = this.getColumns();
        Object[] list = new Object[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            JsonNode node = readTree.findValue(columns[i].getName());
            String value = node.asText();
            list[i] = value;
        }
        return list;
    }

    public Column[] getColumns() {
        if (this._columns == null) {
            try (DatastoreConnection openConnection = this._jsonDatastore.openConnection();){
                this._columns = openConnection.getDataContext().getDefaultSchema().getTable(0).getColumns();
            }
        }
        return this._columns;
    }
}

