/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.spark.functions;

import au.com.bytecode.opencsv.CSVParser;
import org.apache.metamodel.csv.CsvConfiguration;
import org.apache.spark.api.java.function.Function;

public final class CsvParserFunction
implements Function<String, Object[]> {
    private static final long serialVersionUID = 1L;
    private final CsvConfiguration _csvConfiguration;

    public CsvParserFunction(CsvConfiguration csvConfiguration) {
        if (csvConfiguration.isMultilineValues()) {
            throw new IllegalStateException("Multiline CSV files are not supported");
        }
        String encoding = csvConfiguration.getEncoding();
        switch (encoding.toUpperCase()) {
            case "UTF-8": 
            case "UTF8": {
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported encoding: '" + encoding + "'. CSV files on Hadoop must be UTF-8 encoded.");
            }
        }
        this._csvConfiguration = csvConfiguration;
    }

    public Object[] call(String csvLine) throws Exception {
        CSVParser csvParser = new CSVParser(this._csvConfiguration.getSeparatorChar(), this._csvConfiguration.getQuoteChar(), this._csvConfiguration.getEscapeChar());
        Object[] values = csvParser.parseLine(csvLine);
        return values;
    }
}

