/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.spark.functions;

import java.util.Arrays;
import org.apache.spark.api.java.function.Function2;
import org.datacleaner.api.AnalyzerResult;
import org.datacleaner.api.AnalyzerResultReducer;
import org.datacleaner.configuration.DataCleanerConfiguration;
import org.datacleaner.configuration.InjectionManager;
import org.datacleaner.descriptors.ComponentDescriptor;
import org.datacleaner.descriptors.Descriptors;
import org.datacleaner.descriptors.ResultDescriptor;
import org.datacleaner.job.ComponentJob;
import org.datacleaner.lifecycle.LifeCycleHelper;
import org.datacleaner.spark.NamedAnalyzerResult;
import org.datacleaner.spark.SparkJobContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnalyzerResultReduceFunction
implements Function2<NamedAnalyzerResult, NamedAnalyzerResult, NamedAnalyzerResult> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(AnalyzerResultReduceFunction.class);
    private final SparkJobContext _sparkJobContext;

    public AnalyzerResultReduceFunction(SparkJobContext sparkJobContext) {
        this._sparkJobContext = sparkJobContext;
    }

    public NamedAnalyzerResult call(NamedAnalyzerResult namedAnalyzerResult1, NamedAnalyzerResult namedAnalyzerResult2) throws Exception {
        assert (namedAnalyzerResult1.getName().equals(namedAnalyzerResult2.getName()));
        String key = namedAnalyzerResult1.getName();
        ComponentJob componentJob = this._sparkJobContext.getComponentByKey(key);
        AnalyzerResult analyzerResult1 = namedAnalyzerResult1.getAnalyzerResult();
        AnalyzerResult analyzerResult2 = namedAnalyzerResult2.getAnalyzerResult();
        logger.info("Reducing results with key '{}' of types: {} and {}", new Object[]{key, analyzerResult1.getClass(), analyzerResult2.getClass()});
        ResultDescriptor rd = this.getResultDescriptor(componentJob, analyzerResult1);
        Class resultReducerClass = rd.getResultReducerClass();
        if (resultReducerClass == null) {
            throw new IllegalStateException("The analyzer (" + analyzerResult1 + ") is not distributable!");
        }
        AnalyzerResultReducer<AnalyzerResult> reducer = this.initializeReducer(resultReducerClass);
        AnalyzerResult reducedAnalyzerResult = reducer.reduce(Arrays.asList(analyzerResult1, analyzerResult2));
        NamedAnalyzerResult reducedTuple = new NamedAnalyzerResult(key, reducedAnalyzerResult);
        return reducedTuple;
    }

    private AnalyzerResultReducer<AnalyzerResult> initializeReducer(Class<? extends AnalyzerResultReducer<?>> resultReducerClass) {
        DataCleanerConfiguration configuration = this._sparkJobContext.getConfiguration();
        InjectionManager injectionManager = configuration.getEnvironment().getInjectionManagerFactory().getInjectionManager(configuration, this._sparkJobContext.getAnalysisJob());
        LifeCycleHelper lifeCycleHelper = new LifeCycleHelper(injectionManager, false);
        ComponentDescriptor reducerDescriptor = Descriptors.ofComponent(resultReducerClass);
        AnalyzerResultReducer reducer = (AnalyzerResultReducer)reducerDescriptor.newInstance();
        lifeCycleHelper.assignProvidedProperties(reducerDescriptor, (Object)reducer);
        lifeCycleHelper.initialize(reducerDescriptor, (Object)reducer);
        return reducer;
    }

    protected ResultDescriptor getResultDescriptor(ComponentJob componentJob, AnalyzerResult analyzerResult) {
        ComponentDescriptor descriptor = componentJob.getDescriptor();
        if (descriptor instanceof ResultDescriptor) {
            return (ResultDescriptor)descriptor;
        }
        return Descriptors.ofResult((AnalyzerResult)analyzerResult);
    }
}

