/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.spark;

import com.google.common.base.Strings;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.metamodel.util.CollectionUtils;
import org.apache.metamodel.util.FileHelper;
import org.apache.metamodel.util.FileResource;
import org.apache.metamodel.util.Func;
import org.apache.metamodel.util.HdfsResource;
import org.apache.metamodel.util.Resource;
import org.datacleaner.configuration.ConfigurationReaderInterceptor;
import org.datacleaner.configuration.DataCleanerConfiguration;
import org.datacleaner.configuration.JaxbConfigurationReader;
import org.datacleaner.job.AnalysisJob;
import org.datacleaner.job.ComponentJob;
import org.datacleaner.job.JaxbJobReader;
import org.datacleaner.job.OutputDataStreamJob;
import org.datacleaner.job.builder.AnalysisJobBuilder;
import org.datacleaner.job.builder.ComponentBuilder;
import org.datacleaner.spark.SparkConfigurationReaderInterceptor;
import org.datacleaner.spark.SparkJobLifeCycleListener;
import org.datacleaner.util.InputStreamToPropertiesMapFunc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkJobContext
implements Serializable {
    private static final String METADATA_PROPERTY_COMPONENT_INDEX = "org.datacleaner.spark.component.index";
    private static final Logger logger = LoggerFactory.getLogger(SparkJobContext.class);
    private static final String PROPERTY_RESULT_PATH = "datacleaner.result.hdfs.path";
    private static final String PROPERTY_RESULT_ENABLED = "datacleaner.result.hdfs.enabled";
    private static final long serialVersionUID = 1L;
    private final String _configurationXml;
    private final String _analysisJobXml;
    private final String _analysisJobXmlPath;
    private final Map<String, String> _customProperties;
    private final List<SparkJobLifeCycleListener> _sparkJobLifeCycleListeners = new ArrayList<SparkJobLifeCycleListener>();
    private transient DataCleanerConfiguration _dataCleanerConfiguration;
    private transient AnalysisJobBuilder _analysisJobBuilder;

    public SparkJobContext(String dataCleanerConfigurationPath, String analysisJobXmlPath) {
        this(dataCleanerConfigurationPath, analysisJobXmlPath, null);
    }

    public SparkJobContext(String dataCleanerConfigurationPath, String analysisJobXmlPath, String propertiesPath) {
        this._customProperties = this.readCustomProperties(propertiesPath);
        this._configurationXml = this.readFile(dataCleanerConfigurationPath);
        this._analysisJobXml = this.readFile(analysisJobXmlPath);
        this._analysisJobXmlPath = analysisJobXmlPath;
    }

    private static Resource createResource(String path) {
        if (Strings.isNullOrEmpty((String)path)) {
            return null;
        }
        if (path.toLowerCase().startsWith("hdfs:")) {
            return new HdfsResource(path);
        }
        return new FileResource(path);
    }

    private String readFile(String path) {
        Resource resource = SparkJobContext.createResource(path);
        assert (resource != null);
        return (String)resource.read((Func)new Func<InputStream, String>(){

            public String eval(InputStream in) {
                return FileHelper.readInputStreamAsString((InputStream)in, (String)"UTF-8");
            }
        });
    }

    public DataCleanerConfiguration getConfiguration() {
        if (this._dataCleanerConfiguration == null) {
            JaxbConfigurationReader confReader = new JaxbConfigurationReader((ConfigurationReaderInterceptor)new SparkConfigurationReaderInterceptor(this._customProperties));
            this._dataCleanerConfiguration = confReader.read(this.createInputStream(this._configurationXml));
        }
        return this._dataCleanerConfiguration;
    }

    private InputStream createInputStream(String fileContents) {
        try {
            byte[] bytes = fileContents.getBytes("UTF-8");
            return new ByteArrayInputStream(bytes);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    private Map<String, String> readCustomProperties(String propertiesPath) {
        Resource propertiesResource = SparkJobContext.createResource(propertiesPath);
        if (propertiesResource != null && propertiesResource.isExists()) {
            return (Map)propertiesResource.read((Func)new InputStreamToPropertiesMapFunc());
        }
        return Collections.emptyMap();
    }

    public AnalysisJob getAnalysisJob() {
        return this.getAnalysisJobBuilder().toAnalysisJob();
    }

    public AnalysisJobBuilder getAnalysisJobBuilder() {
        if (this._analysisJobBuilder == null) {
            DataCleanerConfiguration configuration = this.getConfiguration();
            JaxbJobReader jobReader = new JaxbJobReader(configuration);
            this._analysisJobBuilder = jobReader.create(this.createInputStream(this._analysisJobXml), this._customProperties);
        }
        this.applyComponentIndexForKeyLookups(this._analysisJobBuilder, new AtomicInteger(0));
        return this._analysisJobBuilder;
    }

    private void applyComponentIndexForKeyLookups(AnalysisJobBuilder analysisJobBuilder, AtomicInteger currentComponentIndex) {
        Collection componentBuilders = analysisJobBuilder.getComponentBuilders();
        for (ComponentBuilder componentBuilder : componentBuilders) {
            componentBuilder.setMetadataProperty(METADATA_PROPERTY_COMPONENT_INDEX, Integer.toString(currentComponentIndex.getAndIncrement()));
        }
        List childJobBuilders = analysisJobBuilder.getConsumedOutputDataStreamsJobBuilders();
        for (AnalysisJobBuilder childJobBuilder : childJobBuilders) {
            this.applyComponentIndexForKeyLookups(childJobBuilder, currentComponentIndex);
        }
    }

    public String getComponentKey(ComponentJob componentJob) {
        String key = (String)componentJob.getMetadataProperties().get(METADATA_PROPERTY_COMPONENT_INDEX);
        if (key == null) {
            throw new IllegalArgumentException("Cannot find component in job: " + componentJob);
        }
        return key;
    }

    public ComponentJob getComponentByKey(String key) {
        AnalysisJob job = this.getAnalysisJob();
        ComponentJob result = this.getComponentByKey(job, key);
        if (result == null) {
            throw new IllegalArgumentException("Cannot resolve component with key: " + key);
        }
        return result;
    }

    private ComponentJob getComponentByKey(AnalysisJob job, String queriedKey) {
        List componentJobs = CollectionUtils.concat((boolean)false, (Collection)job.getTransformerJobs(), (Collection[])new Collection[]{job.getTransformerJobs(), job.getAnalyzerJobs()});
        for (ComponentJob componentJob : componentJobs) {
            OutputDataStreamJob[] outputDataStreamJobs;
            String componentKey = (String)componentJob.getMetadataProperties().get(METADATA_PROPERTY_COMPONENT_INDEX);
            if (componentKey == null) {
                throw new IllegalStateException("No key registered for component: " + componentJob);
            }
            if (queriedKey.equals(componentKey)) {
                return componentJob;
            }
            for (OutputDataStreamJob outputDataStreamJob : outputDataStreamJobs = componentJob.getOutputDataStreamJobs()) {
                ComponentJob result;
                AnalysisJob childJob = outputDataStreamJob.getJob();
                if (childJob == null || (result = this.getComponentByKey(childJob, queriedKey)) == null) continue;
                return result;
            }
        }
        return null;
    }

    public String getResultPath() {
        return this._customProperties.get(PROPERTY_RESULT_PATH);
    }

    public boolean isResultEnabled() {
        String enabledString = this._customProperties.get(PROPERTY_RESULT_ENABLED);
        return !"false".equalsIgnoreCase(enabledString);
    }

    public String getAnalysisJobName() {
        int lastIndexOfSlash = this._analysisJobXmlPath.lastIndexOf("/");
        int lastIndexOfFileExtension = this._analysisJobXmlPath.lastIndexOf(".analysis.xml");
        String jobName = this._analysisJobXmlPath.substring(lastIndexOfSlash + 1, lastIndexOfFileExtension);
        return jobName;
    }

    public void addSparkJobLifeCycleListener(SparkJobLifeCycleListener sparkJobLifeCycleListener) {
        this._sparkJobLifeCycleListeners.add(sparkJobLifeCycleListener);
    }

    public void removeSparkJobLifeCycleListener(SparkJobLifeCycleListener sparkJobLifeCycleListener) {
        this._sparkJobLifeCycleListeners.remove(sparkJobLifeCycleListener);
    }

    public void triggerOnPartitionProcessingEnd() {
        for (SparkJobLifeCycleListener listener : this._sparkJobLifeCycleListeners) {
            try {
                listener.onPartitionProcessingEnd();
            }
            catch (Throwable e) {
                logger.warn("onPartitionProcessingEnd: Listener {} threw exception", (Object)listener, (Object)e);
            }
        }
    }

    public void triggerOnPartitionProcessingStart() {
        for (SparkJobLifeCycleListener listener : this._sparkJobLifeCycleListeners) {
            try {
                listener.onPartitionProcessingStart();
            }
            catch (Throwable e) {
                logger.warn("onPartitionProcessingStart: Listener {} threw exception", (Object)listener, (Object)e);
            }
        }
    }

    public void triggerOnJobStart() {
        for (SparkJobLifeCycleListener listener : this._sparkJobLifeCycleListeners) {
            try {
                listener.onJobStart();
            }
            catch (Throwable e) {
                logger.warn("onJobStart: Listener {} threw exception", (Object)listener, (Object)e);
            }
        }
    }

    public void triggerOnJobEnd() {
        for (SparkJobLifeCycleListener listener : this._sparkJobLifeCycleListeners) {
            try {
                listener.onJobEnd();
            }
            catch (Throwable e) {
                logger.warn("onJobEnd: Listener {} threw exception", (Object)listener, (Object)e);
            }
        }
    }
}

