/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.spark;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.datacleaner.api.AnalyzerResult;
import org.datacleaner.job.ComponentJob;
import org.datacleaner.job.runner.AnalysisJobFailedException;
import org.datacleaner.job.runner.AnalysisResultFuture;
import org.datacleaner.job.runner.JobStatus;
import org.datacleaner.result.AbstractAnalysisResult;
import org.datacleaner.spark.SparkJobContext;
import scala.Tuple2;

public class SparkAnalysisResultFuture
extends AbstractAnalysisResult
implements AnalysisResultFuture {
    private final Date _creationDate = new Date();
    private final List<Tuple2<String, AnalyzerResult>> _results;
    private final SparkJobContext _sparkJobContext;

    public SparkAnalysisResultFuture(List<Tuple2<String, AnalyzerResult>> results, SparkJobContext sparkJobContext) {
        this._results = results;
        this._sparkJobContext = sparkJobContext;
    }

    public boolean isErrornous() {
        return false;
    }

    public boolean isCancelled() {
        return false;
    }

    public Date getCreationDate() {
        return this._creationDate;
    }

    public boolean isDone() {
        return true;
    }

    public void await(long timeout, TimeUnit timeUnit) {
    }

    public void await() {
    }

    public void cancel() {
    }

    public boolean isSuccessful() {
        return true;
    }

    public JobStatus getStatus() {
        return JobStatus.SUCCESSFUL;
    }

    public List<AnalyzerResult> getResults() throws AnalysisJobFailedException {
        ArrayList<AnalyzerResult> list = new ArrayList<AnalyzerResult>();
        for (Tuple2<String, AnalyzerResult> tuple : this._results) {
            list.add((AnalyzerResult)tuple._2);
        }
        return list;
    }

    public Map<ComponentJob, AnalyzerResult> getResultMap() throws AnalysisJobFailedException {
        HashMap<ComponentJob, AnalyzerResult> resultMap = new HashMap<ComponentJob, AnalyzerResult>();
        for (Tuple2<String, AnalyzerResult> tuple : this._results) {
            ComponentJob component = this._sparkJobContext.getComponentByKey((String)tuple._1);
            AnalyzerResult analyzerResult = (AnalyzerResult)tuple._2;
            if (analyzerResult == null) continue;
            resultMap.put(component, analyzerResult);
        }
        return resultMap;
    }

    public List<Throwable> getErrors() {
        return Collections.emptyList();
    }
}

