/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.spark;

import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang.SerializationException;
import org.apache.metamodel.util.HdfsResource;
import org.apache.metamodel.util.Resource;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaSparkContext;
import org.datacleaner.job.runner.AnalysisResultFuture;
import org.datacleaner.result.AnalysisResult;
import org.datacleaner.result.save.AnalysisResultSaveHandler;
import org.datacleaner.spark.SparkAnalysisRunner;
import org.datacleaner.spark.SparkJobContext;
import org.datacleaner.spark.utils.ResultFilePathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger logger = LoggerFactory.getLogger(Main.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        block10: {
            String resultJobFilePath;
            if (args.length < 2) {
                throw new IllegalArgumentException("The number of arguments is incorrect. Usage:\n <configuration file (conf.xml) path> <job file (.analysis.xml) path> [properties file path]\nGot: " + Arrays.toString(args));
            }
            SparkConf conf = new SparkConf().setAppName("DataCleaner-spark");
            JavaSparkContext sparkContext = new JavaSparkContext(conf);
            String confXmlPath = args[0];
            String analysisJobXmlPath = args[1];
            String propertiesPath = args.length > 2 ? args[2] : null;
            SparkJobContext sparkJobContext = new SparkJobContext(confXmlPath, analysisJobXmlPath, propertiesPath);
            if (sparkJobContext.isResultEnabled()) {
                resultJobFilePath = ResultFilePathUtils.getResultFilePath(sparkContext, sparkJobContext);
                logger.info("DataCleaner result will be written to {}", (Object)resultJobFilePath);
            } else {
                resultJobFilePath = null;
            }
            SparkAnalysisRunner sparkAnalysisRunner = new SparkAnalysisRunner(sparkContext, sparkJobContext);
            try {
                AnalysisResultFuture result = sparkAnalysisRunner.run();
                if (resultJobFilePath == null) break block10;
                HdfsResource hdfsResource = new HdfsResource(resultJobFilePath);
                AnalysisResultSaveHandler analysisResultSaveHandler = new AnalysisResultSaveHandler((AnalysisResult)result, (Resource)hdfsResource);
                try {
                    analysisResultSaveHandler.saveOrThrow();
                }
                catch (SerializationException e) {
                    AnalysisResult safeAnalysisResult = analysisResultSaveHandler.createSafeAnalysisResult();
                    if (safeAnalysisResult == null) {
                        logger.error("Serialization of result failed without any safe result elements to persist");
                    } else {
                        Map unsafeResultElements = analysisResultSaveHandler.getUnsafeResultElements();
                        logger.error("Serialization of result failed with the following unsafe elements: {}", (Object)unsafeResultElements);
                        logger.warn("Partial AnalysisResult will be persisted to filename '{}'", (Object)resultJobFilePath);
                        analysisResultSaveHandler.saveWithoutUnsafeResultElements();
                    }
                    throw e;
                }
            }
            finally {
                sparkContext.stop();
            }
        }
    }
}

