/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.data;

import de.odysseus.el.ExpressionFactoryImpl;
import de.odysseus.el.util.SimpleContext;
import java.util.List;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import org.datacleaner.api.ExpressionBasedInputColumn;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.data.AbstractExpressionBasedInputColumn;
import org.datacleaner.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ELInputColumn
extends AbstractExpressionBasedInputColumn<String> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(ELInputColumn.class);
    private final ExpressionFactory _factory;
    private final String _expression;

    public ELInputColumn(String expression) {
        this._expression = expression;
        this._factory = new ExpressionFactoryImpl();
    }

    public String evaluate(InputRow row) {
        SimpleContext context = new SimpleContext();
        List inputColumns = row.getInputColumns();
        for (InputColumn inputColumn : inputColumns) {
            if (inputColumn instanceof ExpressionBasedInputColumn) continue;
            Object value = row.getValue(inputColumn);
            Class javaType = inputColumn.getDataType();
            ValueExpression valueExpression = this._factory.createValueExpression(value, javaType);
            String variableName = inputColumn.getName();
            variableName = StringUtils.replaceWhitespaces((String)variableName, (String)"_");
            context.setVariable(variableName, valueExpression);
        }
        try {
            ValueExpression valueExpression = this._factory.createValueExpression((ELContext)context, this._expression, String.class);
            return (String)valueExpression.getValue((ELContext)context);
        }
        catch (ELException e) {
            logger.error("Could not evaluate EL expression", (Throwable)e);
            return null;
        }
    }

    public String getExpression() {
        return this._expression;
    }

    public Class<? extends String> getDataType() {
        return String.class;
    }
}

