/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.beans.transform;

import de.odysseus.el.ExpressionFactoryImpl;
import de.odysseus.el.ObjectValueExpression;
import de.odysseus.el.TreeValueExpression;
import de.odysseus.el.util.SimpleContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.inject.Named;
import org.datacleaner.api.Categorized;
import org.datacleaner.api.Configured;
import org.datacleaner.api.Description;
import org.datacleaner.api.Initialize;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.api.OutputColumns;
import org.datacleaner.api.StringProperty;
import org.datacleaner.api.Transformer;
import org.datacleaner.components.categories.NumbersCategory;
import org.datacleaner.util.StringUtils;

@Named(value="Math formula")
@Description(value="Provide a mathematical formula to perform arbitrary calculations.\nFormulas support basic operators like plus (+), minus (-), divide (/), multiply (*) and modulus (%).")
@Categorized(value={NumbersCategory.class})
public class MathFormulaTransformer
implements Transformer {
    @Configured
    InputColumn<Number>[] _input;
    @Configured
    @StringProperty(emptyString=false, mimeType={"text/groovy"})
    String _formula = "(col1 + col2) / col3";
    private ExpressionFactoryImpl _factory;
    private Map<String, List<String>> _columnAliases;

    public OutputColumns getOutputColumns() {
        return new OutputColumns(Number.class, "Formula result", new String[0]);
    }

    @Initialize
    public void init() {
        this._factory = new ExpressionFactoryImpl();
        this._columnAliases = new HashMap<String, List<String>>();
        int i = 1;
        for (InputColumn<Number> inputColumn : this._input) {
            String name = inputColumn.getName();
            ArrayList<String> list = new ArrayList<String>(3);
            String variableName1 = StringUtils.replaceWhitespaces((String)name.toLowerCase(), (String)"_");
            String variableName2 = StringUtils.replaceWhitespaces((String)name.toLowerCase(), (String)"");
            list.add(variableName1);
            list.add(variableName2);
            list.add("col" + i);
            ++i;
            this._columnAliases.put(name, list);
        }
    }

    public Number[] transform(InputRow inputRow) {
        SimpleContext context = new SimpleContext();
        for (InputColumn<Number> inputColumn : this._input) {
            Number value = (Number)inputRow.getValue(inputColumn);
            ObjectValueExpression valueExpression = this._factory.createValueExpression((Object)value, Number.class);
            List<String> aliases = this._columnAliases.get(inputColumn.getName());
            for (String alias : aliases) {
                context.setVariable(alias, (ValueExpression)valueExpression);
            }
        }
        String expression = "#{" + this._formula.toLowerCase() + "}";
        TreeValueExpression valueExpression = this._factory.createValueExpression((ELContext)context, expression, Number.class);
        try {
            double dbl;
            Object value = valueExpression.getValue((ELContext)context);
            assert (value instanceof Number);
            if (value instanceof Double && (Double.isNaN(dbl = ((Double)value).doubleValue()) || Double.isInfinite(dbl))) {
                return new Number[]{null};
            }
            return new Number[]{(Number)value};
        }
        catch (ArithmeticException e) {
            return new Number[]{null};
        }
    }
}

