/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.beans.transform;

import javax.inject.Named;
import org.datacleaner.api.Categorized;
import org.datacleaner.api.Configured;
import org.datacleaner.api.Description;
import org.datacleaner.api.ExpressionBasedInputColumn;
import org.datacleaner.api.Initialize;
import org.datacleaner.api.InputRow;
import org.datacleaner.api.OutputColumns;
import org.datacleaner.api.Transformer;
import org.datacleaner.components.categories.ScriptingCategory;
import org.datacleaner.data.ConstantInputColumn;
import org.datacleaner.data.ELInputColumn;

@Named(value="Expression language (EL) transformer")
@Description(value="Generates a column based on an EL expression")
@Categorized(value={ScriptingCategory.class})
public class ELTransformer
implements Transformer {
    @Configured
    String _expression;
    private ExpressionBasedInputColumn<String> _column;

    public OutputColumns getOutputColumns() {
        return new OutputColumns(1, String.class);
    }

    @Initialize
    public void init() {
        this._column = this._expression.indexOf("#{") == -1 ? new ConstantInputColumn(this._expression) : new ELInputColumn(this._expression);
    }

    public String[] transform(InputRow inputRow) {
        String result = (String)this._column.evaluate(inputRow);
        return new String[]{result};
    }
}

