package org.eluder.coveralls.maven.plugin.source;

/*
 * #[license]
 * coveralls-maven-plugin
 * %%
 * Copyright (C) 2013 - 2016 Tapio Rautonen
 * %%
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * %[license]
 */

import org.eluder.coveralls.maven.plugin.ProcessingException;
import org.eluder.coveralls.maven.plugin.domain.Source;

import java.io.IOException;

/**
 * Source callback handles parsed source files from coverage reports.
 */
public interface SourceCallback {

    /**
     * Called before source parsing has started.
     *
     * @throws ProcessingException if processing fails
     * @throws IOException if an I/O error occurs
     */
    void onBegin() throws ProcessingException, IOException;

    /**
     * Handles a parsed source file.
     * 
     * @param source the source file
     * @throws ProcessingException if further processing of the source fails
     * @throws IOException if an I/O error occurs
     */
    void onSource(Source source) throws ProcessingException, IOException;

    /**
     * Called after all sources are handled.
     *
     * @throws ProcessingException if processing fails
     * @throws IOException if an I/O error occurs
     */
    void onComplete() throws ProcessingException, IOException;
    
}
