/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.spark.rdd;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.spark.TaskContext;
import org.apache.spark.util.TaskCompletionListener;
import org.elasticsearch.hadoop.cfg.PropertiesSettings;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.mr.security.HadoopUserProvider;
import org.elasticsearch.hadoop.rest.InitializationUtils;
import org.elasticsearch.hadoop.rest.RestService;
import org.elasticsearch.hadoop.security.UserProvider;
import org.elasticsearch.hadoop.serialization.BytesConverter;
import org.elasticsearch.hadoop.serialization.JdkBytesConverter;
import org.elasticsearch.hadoop.serialization.builder.ValueWriter;
import org.elasticsearch.hadoop.serialization.bulk.MetadataExtractor;
import org.elasticsearch.hadoop.serialization.field.FieldExtractor;
import org.elasticsearch.hadoop.util.ObjectUtils;
import org.elasticsearch.spark.rdd.EsRDDWriter$;
import org.elasticsearch.spark.serialization.ScalaMapFieldExtractor;
import org.elasticsearch.spark.serialization.ScalaMetadataExtractor;
import org.elasticsearch.spark.serialization.ScalaValueWriter;
import scala.MatchError;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Eh!\u0002\f\u0018\u0001ey\u0002\u0002\u0003\u0016\u0001\u0005\u000b\u0007I\u0011\u0001\u0017\t\u0011a\u0002!\u0011!Q\u0001\n5B\u0001\"\u000f\u0001\u0003\u0006\u0004%\tA\u000f\u0005\t}\u0001\u0011\t\u0011)A\u0005w!Aq\b\u0001B\u0002B\u0003-\u0001\tC\u0003R\u0001\u0011\u0005!\u000b\u0003\u0005Z\u0001!\u0015\r\u0011\"\u0005[\u0011!I\u0007\u0001#b\u0001\n\u0003Q\u0007\u0002C:\u0001\u0011\u000b\u0007I\u0011\u0001;\t\u000bu\u0004A\u0011\u0001@\t\u000f\u0005%\u0002\u0001\"\u0005\u0002,!9\u00111\u000b\u0001\u0005\u0012\u0005U\u0003bBA6\u0001\u0011E\u0011Q\u000e\u0005\b\u0003\u000f\u0003A\u0011CAE\u0011\u001d\t9\n\u0001C\t\u00033Cq!a-\u0001\t#\t)l\u0002\u0006\u0002:^\t\t\u0011#\u0001\u001a\u0003w3\u0011BF\f\u0002\u0002#\u0005\u0011$!0\t\rE\u0013B\u0011AA`\u0011%\t\tMEI\u0001\n\u0003\t\u0019\rC\u0005\u0002^J\t\t\u0011\"\u0003\u0002`\nYQi\u001d*E\t^\u0013\u0018\u000e^3s\u0015\tA\u0012$A\u0002sI\u0012T!AG\u000e\u0002\u000bM\u0004\u0018M]6\u000b\u0005qi\u0012!D3mCN$\u0018nY:fCJ\u001c\u0007NC\u0001\u001f\u0003\ry'oZ\u000b\u0003A!\u001b2\u0001A\u0011(!\t\u0011S%D\u0001$\u0015\u0005!\u0013!B:dC2\f\u0017B\u0001\u0014$\u0005\u0019\te.\u001f*fMB\u0011!\u0005K\u0005\u0003S\r\u0012AbU3sS\u0006d\u0017N_1cY\u0016\f!c]3sS\u0006d\u0017N_3e'\u0016$H/\u001b8hg\u000e\u0001Q#A\u0017\u0011\u00059*dBA\u00184!\t\u00014%D\u00012\u0015\t\u00114&\u0001\u0004=e>|GOP\u0005\u0003i\r\na\u0001\u0015:fI\u00164\u0017B\u0001\u001c8\u0005\u0019\u0019FO]5oO*\u0011AgI\u0001\u0014g\u0016\u0014\u0018.\u00197ju\u0016$7+\u001a;uS:<7\u000fI\u0001\u0010eVtG/[7f\u001b\u0016$\u0018\rZ1uCV\t1\b\u0005\u0002#y%\u0011Qh\t\u0002\b\u0005>|G.Z1o\u0003A\u0011XO\u001c;j[\u0016lU\r^1eCR\f\u0007%\u0001\u0006fm&$WM\\2fIE\u00022!\u0011#G\u001b\u0005\u0011%BA\"$\u0003\u001d\u0011XM\u001a7fGRL!!\u0012\"\u0003\u0011\rc\u0017m]:UC\u001e\u0004\"a\u0012%\r\u0001\u0011)\u0011\n\u0001b\u0001\u0015\n\tA+\u0005\u0002L\u001dB\u0011!\u0005T\u0005\u0003\u001b\u000e\u0012qAT8uQ&tw\r\u0005\u0002#\u001f&\u0011\u0001k\t\u0002\u0004\u0003:L\u0018A\u0002\u001fj]&$h\bF\u0002T/b#\"\u0001\u0016,\u0011\u0007U\u0003a)D\u0001\u0018\u0011\u0015yd\u0001q\u0001A\u0011\u0015Qc\u00011\u0001.\u0011\u001dId\u0001%AA\u0002m\n1\u0001\\8h+\u0005Y\u0006C\u0001/d\u001b\u0005i&B\u00010`\u0003\u001dawnZ4j]\u001eT!\u0001Y1\u0002\u000f\r|W.\\8og*\u0011!-H\u0001\u0007CB\f7\r[3\n\u0005\u0011l&a\u0001'pO\"\u0012qA\u001a\t\u0003E\u001dL!\u0001[\u0012\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018\u0001C:fiRLgnZ:\u0016\u0003-\u0004\"\u0001\\9\u000e\u00035T!A\\8\u0002\u0007\r4wM\u0003\u0002q7\u00051\u0001.\u00193p_BL!A]7\u0003\u0011M+G\u000f^5oON\fQ\"\\3uC\u0016CHO]1di>\u0014X#A;\u0011\u0005Y\\X\"A<\u000b\u0005aL\u0018\u0001\u00022vY.T!A_8\u0002\u001bM,'/[1mSj\fG/[8o\u0013\taxOA\tNKR\fG-\u0019;b\u000bb$(/Y2u_J\fQa\u001e:ji\u0016$Ra`A\u0003\u0003'\u00012AIA\u0001\u0013\r\t\u0019a\t\u0002\u0005+:LG\u000fC\u0004\u0002\b)\u0001\r!!\u0003\u0002\u0017Q\f7o[\"p]R,\u0007\u0010\u001e\t\u0005\u0003\u0017\ty!\u0004\u0002\u0002\u000e)\u0011!$Y\u0005\u0005\u0003#\tiAA\u0006UCN\\7i\u001c8uKb$\bbBA\u000b\u0015\u0001\u0007\u0011qC\u0001\u0005I\u0006$\u0018\rE\u0003\u0002\u001a\u0005\rbI\u0004\u0003\u0002\u001c\u0005}ab\u0001\u0019\u0002\u001e%\tA%C\u0002\u0002\"\r\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002&\u0005\u001d\"\u0001C%uKJ\fGo\u001c:\u000b\u0007\u0005\u00052%A\u0006wC2,Xm\u0016:ji\u0016\u0014XCAA\u0017a\u0011\ty#a\u000e\u0011\u000b9\n\t$!\u000e\n\u0007\u0005MrGA\u0003DY\u0006\u001c8\u000fE\u0002H\u0003o!1\"!\u000f\f\u0003\u0003\u0005\tQ!\u0001\u0002<\t\u0019q\fJ\u0019\u0012\u0007-\u000bi\u0004\r\u0003\u0002@\u00055\u0003CBA!\u0003\u000f\nY%\u0004\u0002\u0002D)\u0019\u0011QI=\u0002\u000f\t,\u0018\u000e\u001c3fe&!\u0011\u0011JA\"\u0005-1\u0016\r\\;f/JLG/\u001a:\u0011\u0007\u001d\u000bi\u0005B\u0006\u0002P\u0005E\u0013\u0011!A\u0001\u0006\u0003Q%aA0%e\u0011Y\u0011\u0011H\u0006\u0002\u0002\u0007\u0005)\u0011AA\u001e\u00039\u0011\u0017\u0010^3t\u0007>tg/\u001a:uKJ,\"!a\u00161\t\u0005e\u0013Q\f\t\u0006]\u0005E\u00121\f\t\u0004\u000f\u0006uCaCA0\u0019\u0005\u0005\t\u0011!B\u0001\u0003C\u00121a\u0018\u00134#\rY\u00151\r\t\u0005\u0003K\n9'D\u0001z\u0013\r\tI'\u001f\u0002\u000f\u0005f$Xm]\"p]Z,'\u000f^3s\u000391\u0017.\u001a7e\u000bb$(/Y2u_J,\"!a\u001c1\t\u0005E\u0014Q\u000f\t\u0006]\u0005E\u00121\u000f\t\u0004\u000f\u0006UDaCA<\u001b\u0005\u0005\t\u0011!B\u0001\u0003s\u00121a\u0018\u00135#\rY\u00151\u0010\t\u0005\u0003{\n\u0019)\u0004\u0002\u0002\u0000)\u0019\u0011\u0011Q=\u0002\u000b\u0019LW\r\u001c3\n\t\u0005\u0015\u0015q\u0010\u0002\u000f\r&,G\u000eZ#yiJ\f7\r^8s\u0003EiW\r^1eCR\fW\t\u001f;sC\u000e$xN]\u000b\u0003\u0003\u0017\u0003D!!$\u0002\u0012B)a&!\r\u0002\u0010B\u0019q)!%\u0005\u0017\u0005Me\"!A\u0001\u0002\u000b\u0005\u0011Q\u0013\u0002\u0004?\u0012*\u0014CA&v\u00031)8/\u001a:Qe>4\u0018\u000eZ3s+\t\tY\n\r\u0003\u0002\u001e\u0006\u0005\u0006#\u0002\u0018\u00022\u0005}\u0005cA$\u0002\"\u0012Y\u00111U\b\u0002\u0002\u0003\u0005)\u0011AAS\u0005\ryFEN\t\u0004\u0017\u0006\u001d\u0006\u0003BAU\u0003_k!!a+\u000b\u0007\u00055v.\u0001\u0005tK\u000e,(/\u001b;z\u0013\u0011\t\t,a+\u0003\u0019U\u001bXM\u001d)s_ZLG-\u001a:\u0002\u0017A\u0014xnY3tg\u0012\u000bG/\u0019\u000b\u0004\u001d\u0006]\u0006bBA\u000b!\u0001\u0007\u0011qC\u0001\f\u000bN\u0014F\tR,sSR,'\u000f\u0005\u0002V%M\u0019!#I\u0014\u0015\u0005\u0005m\u0016a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'\u0006\u0003\u0002F\u0006mWCAAdU\rY\u0014\u0011Z\u0016\u0003\u0003\u0017\u0004B!!4\u0002X6\u0011\u0011q\u001a\u0006\u0005\u0003#\f\u0019.A\u0005v]\u000eDWmY6fI*\u0019\u0011Q[\u0012\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002Z\u0006='!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0012)\u0011\n\u0006b\u0001\u0015\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t\t\u000f\u0005\u0003\u0002d\u00065XBAAs\u0015\u0011\t9/!;\u0002\t1\fgn\u001a\u0006\u0003\u0003W\fAA[1wC&!\u0011q^As\u0005\u0019y%M[3di\u0002")
public class EsRDDWriter<T>
implements Serializable {
    private transient Log log;
    private Settings settings;
    private MetadataExtractor metaExtractor;
    private final String serializedSettings;
    private final boolean runtimeMetadata;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static <T> boolean $lessinit$greater$default$2() {
        return EsRDDWriter$.MODULE$.$lessinit$greater$default$2();
    }

    public String serializedSettings() {
        return this.serializedSettings;
    }

    public boolean runtimeMetadata() {
        return this.runtimeMetadata;
    }

    private Log log$lzycompute() {
        EsRDDWriter esRDDWriter = this;
        synchronized (esRDDWriter) {
            if (!this.bitmap$trans$0) {
                this.log = LogFactory.getLog(this.getClass());
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    public Log log() {
        return !this.bitmap$trans$0 ? this.log$lzycompute() : this.log;
    }

    /*
     * WARNING - void declaration
     */
    private Settings settings$lzycompute() {
        EsRDDWriter esRDDWriter = this;
        synchronized (esRDDWriter) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                void var2_2;
                Settings settings = new PropertiesSettings().load(this.serializedSettings());
                InitializationUtils.setValueWriterIfNotSet(settings, this.valueWriter(), this.log());
                InitializationUtils.setBytesConverterIfNeeded(settings, this.bytesConverter(), this.log());
                InitializationUtils.setFieldExtractorIfNotSet(settings, this.fieldExtractor(), this.log());
                InitializationUtils.setMetadataExtractorIfNotSet(settings, this.metadataExtractor(), this.log());
                InitializationUtils.setUserProviderIfNotSet(settings, this.userProvider(), this.log());
                this.settings = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.settings;
    }

    public Settings settings() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.settings$lzycompute() : this.settings;
    }

    private MetadataExtractor metaExtractor$lzycompute() {
        EsRDDWriter esRDDWriter = this;
        synchronized (esRDDWriter) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.metaExtractor = (MetadataExtractor)ObjectUtils.instantiate(this.settings().getMappingMetadataExtractorClassName(), this.settings());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.metaExtractor;
    }

    public MetadataExtractor metaExtractor() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.metaExtractor$lzycompute() : this.metaExtractor;
    }

    public void write(TaskContext taskContext, Iterator<T> data) {
        RestService.PartitionWriter writer = RestService.createWriter(this.settings(), taskContext.partitionId(), -1, this.log());
        TaskCompletionListener listener = new TaskCompletionListener(null, writer){
            private final RestService.PartitionWriter writer$1;

            public void onTaskCompletion(TaskContext context) {
                this.writer$1.close();
            }
            {
                this.writer$1 = writer$1;
            }
        };
        taskContext.addTaskCompletionListener(listener);
        if (this.runtimeMetadata()) {
            writer.repository.addRuntimeFieldExtractor(this.metaExtractor());
        }
        while (data.hasNext()) {
            writer.repository.writeToIndex(this.processData(data));
        }
    }

    public Class<? extends ValueWriter<?>> valueWriter() {
        return ScalaValueWriter.class;
    }

    public Class<? extends BytesConverter> bytesConverter() {
        return JdkBytesConverter.class;
    }

    public Class<? extends FieldExtractor> fieldExtractor() {
        return ScalaMapFieldExtractor.class;
    }

    public Class<? extends MetadataExtractor> metadataExtractor() {
        return ScalaMetadataExtractor.class;
    }

    public Class<? extends UserProvider> userProvider() {
        return HadoopUserProvider.class;
    }

    /*
     * WARNING - void declaration
     */
    public Object processData(Iterator<T> data) {
        Object object;
        Object next = data.next();
        if (this.runtimeMetadata()) {
            Object object2 = next;
            if (!(object2 instanceof Tuple2)) {
                throw new MatchError(object2);
            }
            Tuple2 tuple2 = (Tuple2)object2;
            Object key = tuple2._1();
            Object value = tuple2._2();
            Tuple2 tuple22 = new Tuple2(key, value);
            Tuple2 tuple23 = tuple22;
            Object key2 = tuple23._1();
            Object value2 = tuple23._2();
            this.metaExtractor().setObject(key2);
            object = value2;
        } else {
            void var3_2;
            object = var3_2;
        }
        return object;
    }

    public EsRDDWriter(String serializedSettings, boolean runtimeMetadata, ClassTag<T> evidence$1) {
        this.serializedSettings = serializedSettings;
        this.runtimeMetadata = runtimeMetadata;
    }
}

