/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest.commonshttp.auth.bearer;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.auth.AuthenticationException;
import org.apache.commons.httpclient.auth.BasicScheme;
import org.apache.commons.httpclient.auth.MalformedChallengeException;
import org.elasticsearch.hadoop.rest.commonshttp.auth.bearer.EsApiKeyCredentials;
import org.elasticsearch.hadoop.security.EsToken;
import org.elasticsearch.hadoop.util.StringUtils;

public class EsApiKeyAuthScheme
extends BasicScheme {
    private boolean complete = false;

    public boolean isConnectionBased() {
        return false;
    }

    public String getSchemeName() {
        return "ApiKey";
    }

    public void processChallenge(String challenge) throws MalformedChallengeException {
        this.complete = true;
    }

    private String authenticate(Credentials credentials) throws AuthenticationException {
        if (!(credentials instanceof EsApiKeyCredentials)) {
            throw new AuthenticationException("Incorrect credentials type provided. Expected [" + EsApiKeyCredentials.class.getName() + "] but got [" + credentials.getClass().getName() + "]");
        }
        EsApiKeyCredentials esApiKeyCredentials = (EsApiKeyCredentials)credentials;
        String authString = null;
        if (esApiKeyCredentials.getToken() != null && StringUtils.hasText(esApiKeyCredentials.getToken().getName())) {
            EsToken token = esApiKeyCredentials.getToken();
            String keyComponents = token.getId() + ":" + token.getApiKey();
            byte[] base64Encoded = Base64.encodeBase64((byte[])keyComponents.getBytes(StringUtils.UTF_8));
            String tokenText = new String(base64Encoded, StringUtils.UTF_8);
            authString = "ApiKey " + tokenText;
        }
        return authString;
    }

    public String authenticate(Credentials credentials, HttpMethod method) throws AuthenticationException {
        return this.authenticate(credentials);
    }

    public String authenticate(Credentials credentials, String method, String uri) throws AuthenticationException {
        return this.authenticate(credentials);
    }

    public boolean isComplete() {
        return this.complete;
    }

    public String getRealm() {
        return null;
    }

    public String getParameter(String name) {
        return null;
    }

    public String getID() {
        return this.getSchemeName();
    }
}

