/*
 * Decompiled with CFR 0.152.
 */
package org.elasticmq.server;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ActorSystem$;
import akka.actor.Props$;
import akka.actor.Terminated;
import akka.util.Timeout;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.elasticmq.ElasticMQError;
import org.elasticmq.Limits;
import org.elasticmq.actor.QueueManagerActor;
import org.elasticmq.actor.queue.QueueEvent;
import org.elasticmq.actor.reply.Replyable;
import org.elasticmq.msg.CreateQueue;
import org.elasticmq.persistence.file.ConfigBasedQueuePersistenceActor;
import org.elasticmq.persistence.sql.SqlQueuePersistenceActor;
import org.elasticmq.rest.sqs.SQSRestServer;
import org.elasticmq.rest.sqs.TheSQSRestServerBuilder;
import org.elasticmq.rest.stats.StatisticsRestServer;
import org.elasticmq.rest.stats.TheStatisticsRestServerBuilder;
import org.elasticmq.server.config.ElasticMQServerConfig;
import org.elasticmq.util.Logging;
import org.elasticmq.util.NowProvider;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.UninitializedFieldError;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0005\u0005%b\u0001\u0002\t\u0012\u0001aA\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\u0006W\u0001!\t\u0001\f\u0005\ba\u0001\u0011\r\u0011\"\u00032\u0011\u0019Q\u0004\u0001)A\u0005e!91\b\u0001b\u0001\n\u0007a\u0004BB\"\u0001A\u0003%Q\bC\u0004E\u0001\t\u0007I1A#\t\r-\u0003\u0001\u0015!\u0003G\u0011\u0015a\u0005\u0001\"\u0001N\u0011\u0015!\u0006\u0001\"\u0003V\u0011\u0015a\u0006\u0001\"\u0003^\u0011\u0015\u0001\u0007\u0001\"\u0003b\u0011\u0015q\u0007\u0001\"\u0003p\u0011\u0015A\b\u0001\"\u0003z\u0011\u001d\t\u0019\u0003\u0001C\u0005\u0003K\u0011q\"\u00127bgRL7-T)TKJ4XM\u001d\u0006\u0003%M\taa]3sm\u0016\u0014(B\u0001\u000b\u0016\u0003%)G.Y:uS\u000el\u0017OC\u0001\u0017\u0003\ry'oZ\u0002\u0001'\r\u0001\u0011d\b\t\u00035ui\u0011a\u0007\u0006\u00029\u0005)1oY1mC&\u0011ad\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0005\t\u001a\u0012\u0001B;uS2L!\u0001J\u0011\u0003\u000f1{wmZ5oO\u000611m\u001c8gS\u001e\u0004\"aJ\u0015\u000e\u0003!R!!J\t\n\u0005)B#!F#mCN$\u0018nY'R'\u0016\u0014h/\u001a:D_:4\u0017nZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00055z\u0003C\u0001\u0018\u0001\u001b\u0005\t\u0002\"B\u0013\u0003\u0001\u00041\u0013aC1di>\u00148+_:uK6,\u0012A\r\t\u0003gaj\u0011\u0001\u000e\u0006\u0003kY\nQ!Y2u_JT\u0011aN\u0001\u0005C.\\\u0017-\u0003\u0002:i\tY\u0011i\u0019;peNK8\u000f^3n\u00031\t7\r^8s'f\u001cH/Z7!\u0003\t)7-F\u0001>!\tq\u0014)D\u0001@\u0015\t\u00015$\u0001\u0006d_:\u001cWO\u001d:f]RL!AQ \u00031\u0015CXmY;uS>t7i\u001c8uKb$X\t_3dkR|'/A\u0002fG\u0002\nq\u0001^5nK>,H/F\u0001G!\t9\u0015*D\u0001I\u0015\t\u0011c'\u0003\u0002K\u0011\n9A+[7f_V$\u0018\u0001\u0003;j[\u0016|W\u000f\u001e\u0011\u0002\u000bM$\u0018M\u001d;\u0015\u00039\u00032AG(R\u0013\t\u00016DA\u0005Gk:\u001cG/[8oaA\u00111GU\u0005\u0003'R\u0012!\u0002V3s[&t\u0017\r^3e\u0003a\u0019'/Z1uKF+X-^3Fm\u0016tG\u000fT5ti\u0016tWM]\u000b\u0002-B\u0019!dV-\n\u0005a[\"AB(qi&|g\u000e\u0005\u000245&\u00111\f\u000e\u0002\t\u0003\u000e$xN\u001d*fM\u0006Q1M]3bi\u0016\u0014\u0015m]3\u0015\u0005es\u0006\"B0\f\u0001\u00041\u0016\u0001E9vKV,7i\u001c8gS\u001e\u001cFo\u001c:f\u0003Yy\u0007\u000f^5p]\u0006dG._*uCJ$(+Z:u'F\u001cHc\u00012l[B\u0019!dV2\u0011\u0005\u0011LW\"A3\u000b\u0005\u0019<\u0017aA:rg*\u0011\u0001nE\u0001\u0005e\u0016\u001cH/\u0003\u0002kK\ni1+U*SKN$8+\u001a:wKJDQ\u0001\u001c\u0007A\u0002e\u000b\u0011#];fk\u0016l\u0015M\\1hKJ\f5\r^8s\u0011\u0015yF\u00021\u0001W\u0003uy\u0007\u000f^5p]\u0006dG._*uCJ$(+Z:u'R\fG/[:uS\u000e\u001cHC\u00019x!\rQr+\u001d\t\u0003eVl\u0011a\u001d\u0006\u0003i\u001e\fQa\u001d;biNL!A^:\u0003)M#\u0018\r^5ti&\u001c7OU3tiN+'O^3s\u0011\u0015aW\u00021\u0001Z\u0003\t\u0012Xm\u001d;pe\u0016\fV/Z;fgZK\u0017-U;fk\u0016,e/\u001a8u\u0019&\u001cH/\u001a8feR)!0!\b\u0002\"A\u0019ah_?\n\u0005q|$A\u0002$viV\u0014X\rE\u0002\u001b/z\u0004Ra`A\b\u0003+qA!!\u0001\u0002\f9!\u00111AA\u0005\u001b\t\t)AC\u0002\u0002\b]\ta\u0001\u0010:p_Rt\u0014\"\u0001\u000f\n\u0007\u000551$A\u0004qC\u000e\\\u0017mZ3\n\t\u0005E\u00111\u0003\u0002\u0005\u0019&\u001cHOC\u0002\u0002\u000em\u0001B!a\u0006\u0002\u001a5\t1#C\u0002\u0002\u001cM\u0011a\"\u00127bgRL7-T)FeJ|'\u000f\u0003\u0004\u0002 9\u0001\r!W\u0001\u0018cV,W/Z#wK:$H*[:uK:,'/Q2u_JDQ\u0001\u001c\bA\u0002e\u000bac\u0019:fCR,\u0017+^3vKN4%o\\7D_:4\u0017n\u001a\u000b\u0004u\u0006\u001d\u0002\"\u00027\u0010\u0001\u0004I\u0006")
public class ElasticMQServer
implements Logging {
    private final ElasticMQServerConfig config;
    private final ActorSystem actorSystem;
    private final ExecutionContextExecutor ec;
    private final Timeout timeout;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$init$0;

    private Logger logger$lzycompute() {
        ElasticMQServer elasticMQServer = this;
        synchronized (elasticMQServer) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private ActorSystem actorSystem() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/elasticmq/elasticmq/server/src/main/scala/org/elasticmq/server/ElasticMQServer.scala: 21");
        }
        return this.actorSystem;
    }

    public ExecutionContextExecutor ec() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/elasticmq/elasticmq/server/src/main/scala/org/elasticmq/server/ElasticMQServer.scala: 23");
        }
        return this.ec;
    }

    public Timeout timeout() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/elasticmq/elasticmq/server/src/main/scala/org/elasticmq/server/ElasticMQServer.scala: 24");
        }
        return this.timeout;
    }

    public Function0<Terminated> start() {
        Future future;
        Option<ActorRef> queueConfigStore = this.createQueueEventListener();
        ActorRef queueManagerActor = this.createBase(queueConfigStore);
        Option<SQSRestServer> restServerOpt = this.optionallyStartRestSqs(queueManagerActor, queueConfigStore);
        Option<StatisticsRestServer> restStatisticsServerOpt = this.optionallyStartRestStatistics(queueManagerActor);
        Function0 & Serializable shutdown = (Function0 & Serializable)() -> {
            Future futureTerminationRestSQS = (Future)restServerOpt.map((Function1 & Serializable)x$1 -> (Future)x$1.stopAndGetFuture().apply()).getOrElse((Function0 & Serializable)() -> Future$.MODULE$.unit());
            Future futureTerminationRestStats = (Future)restStatisticsServerOpt.map((Function1 & Serializable)x$2 -> (Future)x$2.stopAndGetFuture().apply()).getOrElse((Function0 & Serializable)() -> Future$.MODULE$.unit());
            Future eventualTerminated = futureTerminationRestSQS.flatMap((Function1 & Serializable)x$4 -> {
                Object object = x$4;
                Future future = futureTerminationRestStats.flatMap((Function1 & Serializable)x$3 -> {
                    Object object = x$3;
                    Future future = this.actorSystem().terminate().map((Function1 & Serializable)ac -> ac, (ExecutionContext)this.ec());
                    return future;
                }, (ExecutionContext)this.ec());
                return future;
            }, (ExecutionContext)this.ec());
            return (Terminated)Await$.MODULE$.result((Awaitable)eventualTerminated, (Duration)Duration$.MODULE$.Inf());
        };
        Function1 & Serializable logErrorsAndShutdown = (Function1 & Serializable)errors -> {
            errors.foreach((Function1 & Serializable)error -> {
                ElasticMQServer.$anonfun$start$10(this, error);
                return BoxedUnit.UNIT;
            });
            return (Terminated)shutdown.apply();
        };
        Option<ActorRef> option = queueConfigStore;
        if (option instanceof Some) {
            Some some = (Some)option;
            ActorRef queueConfigStoreActor = (ActorRef)some.value();
            future = this.restoreQueuesViaQueueEventListener(queueConfigStoreActor, queueManagerActor).map((Function1 & Serializable)x0$1 -> {
                Object object;
                Option option = x0$1;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    List errors = (List)some.value();
                    object = logErrorsAndShutdown.apply((Object)errors);
                } else if (None$.MODULE$.equals(option)) {
                    object = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)option);
                }
                return object;
            }, (ExecutionContext)this.ec());
        } else if (None$.MODULE$.equals(option)) {
            future = this.createQueuesFromConfig(queueManagerActor).map((Function1 & Serializable)x0$2 -> {
                Object object;
                Option option = x0$2;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    List errors = (List)some.value();
                    object = logErrorsAndShutdown.apply((Object)errors);
                } else if (None$.MODULE$.equals(option)) {
                    object = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)option);
                }
                return object;
            }, (ExecutionContext)this.ec());
        } else {
            throw new MatchError(option);
        }
        return shutdown;
    }

    private Option<ActorRef> createQueueEventListener() {
        return this.config.sqlQueuePersistenceConfig().enabled() ? new Some((Object)this.actorSystem().actorOf(Props$.MODULE$.apply((Function0 & Serializable)() -> new SqlQueuePersistenceActor($this.config.sqlQueuePersistenceConfig(), $this.config.baseQueues()), ClassTag$.MODULE$.apply(SqlQueuePersistenceActor.class)))) : (this.config.queuesStorageEnabled() ? new Some((Object)this.actorSystem().actorOf(Props$.MODULE$.apply((Function0 & Serializable)() -> new ConfigBasedQueuePersistenceActor($this.config.queuesStoragePath(), $this.config.baseQueues()), ClassTag$.MODULE$.apply(ConfigBasedQueuePersistenceActor.class)))) : None$.MODULE$);
    }

    private ActorRef createBase(Option<ActorRef> queueConfigStore) {
        return this.actorSystem().actorOf(Props$.MODULE$.apply((Function0 & Serializable)() -> new QueueManagerActor(new NowProvider(), (Limits)$this.config.restSqs().sqsLimits(), queueConfigStore), ClassTag$.MODULE$.apply(QueueManagerActor.class)));
    }

    private Option<SQSRestServer> optionallyStartRestSqs(ActorRef queueManagerActor, Option<ActorRef> queueConfigStore) {
        None$ none$;
        if (this.config.restSqs().enabled()) {
            SQSRestServer server = new TheSQSRestServerBuilder((Option)new Some((Object)this.actorSystem()), (Option)new Some((Object)queueManagerActor), this.config.restSqs().bindHostname(), this.config.restSqs().bindPort(), this.config.nodeAddress(), this.config.generateNodeAddress(), (Limits)this.config.restSqs().sqsLimits(), this.config.awsRegion(), this.config.awsAccountId(), queueConfigStore).start();
            server.waitUntilStarted();
            none$ = new Some((Object)server);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private Option<StatisticsRestServer> optionallyStartRestStatistics(ActorRef queueManagerActor) {
        None$ none$;
        if (this.config.restStatisticsConfiguration().enabled()) {
            StatisticsRestServer server = new TheStatisticsRestServerBuilder(this.actorSystem(), queueManagerActor, this.config.restStatisticsConfiguration().bindHostname(), this.config.restStatisticsConfiguration().bindPort(), this.config.awsRegion(), this.config.awsAccountId(), this.config.nodeAddress().contextPath()).start();
            server.waitUntilStarted();
            none$ = new Some((Object)server);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private Future<Option<List<ElasticMQError>>> restoreQueuesViaQueueEventListener(ActorRef queueEventListenerActor, ActorRef queueManagerActor) {
        return org.elasticmq.actor.reply.package$.MODULE$.ReplyActorRef(queueEventListenerActor).$qmark((Replyable)new QueueEvent.Restore(queueManagerActor), this.timeout(), ClassTag$.MODULE$.apply(Either.class)).map((Function1 & Serializable)x$5 -> x$5.swap().toOption(), (ExecutionContext)this.ec());
    }

    private Future<Option<List<ElasticMQError>>> createQueuesFromConfig(ActorRef queueManagerActor) {
        List createQueuesFutures = this.config.baseQueues().map((Function1 & Serializable)createQueue -> org.elasticmq.actor.reply.package$.MODULE$.ReplyActorRef(queueManagerActor).$qmark((Replyable)new CreateQueue(createQueue.toCreateQueueData()), this.timeout(), ClassTag$.MODULE$.apply(Either.class)).map((Function1 & Serializable)x$6 -> x$6.swap().toOption(), (ExecutionContext)this.ec()));
        return Future$.MODULE$.sequence((IterableOnce)createQueuesFutures, BuildFrom$.MODULE$.buildFromIterableOps(), (ExecutionContext)this.ec()).map((Function1 & Serializable)maybeErrors -> {
            List errors = (List)maybeErrors.flatten(Predef$.MODULE$.$conforms());
            return errors.nonEmpty() ? new Some((Object)errors) : None$.MODULE$;
        }, (ExecutionContext)this.ec());
    }

    public static final /* synthetic */ void $anonfun$start$10(ElasticMQServer $this, ElasticMQError error) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isErrorEnabled()) {
            $this.logger().underlying().error("Could not start server because {}", (Object)error);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public ElasticMQServer(ElasticMQServerConfig config) {
        this.config = config;
        LazyLogging.$init$((LazyLogging)this);
        this.actorSystem = ActorSystem$.MODULE$.apply("elasticmq");
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.ec = this.actorSystem().dispatcher();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.timeout = new Timeout(new package.DurationInt(package$.MODULE$.DurationInt(5)).seconds());
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
    }
}

