/*
 * Decompiled with CFR 0.152.
 */
package org.elasticmq.replication;

import com.typesafe.scalalogging.slf4j.Logger;
import com.typesafe.scalalogging.slf4j.Logging;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticmq.NodeAddress;
import org.elasticmq.marshalling.JavaSerializationMarshaller;
import org.elasticmq.marshalling.ObjectMarshaller;
import org.elasticmq.replication.ClusterState;
import org.elasticmq.replication.CommandReplicationMode;
import org.elasticmq.replication.CommandResultReplicator;
import org.elasticmq.replication.ReplicatedStorage;
import org.elasticmq.replication.ReplicatedStorageConfigurator$;
import org.elasticmq.replication.jgroups.JGroupsMembershipListener;
import org.elasticmq.replication.jgroups.JGroupsReplicatedStorage;
import org.elasticmq.replication.jgroups.JGroupsReplicationMessageSender;
import org.elasticmq.replication.jgroups.JGroupsRequestHandler;
import org.elasticmq.replication.jgroups.JGroupsStateTransferMessageListener;
import org.elasticmq.storage.StorageCommandExecutor;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.MessageListener;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.protocols.pbcast.FLUSH;
import org.jgroups.stack.Protocol;
import scala.Function0;
import scala.None$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001-4A!\u0001\u0002\u0001\u0013\ti\"+\u001a9mS\u000e\fG/\u001a3Ti>\u0014\u0018mZ3D_:4\u0017nZ;sCR|'O\u0003\u0002\u0004\t\u0005Y!/\u001a9mS\u000e\fG/[8o\u0015\t)a!A\u0005fY\u0006\u001cH/[2nc*\tq!A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u0015I\u0001\"a\u0003\t\u000e\u00031Q!!\u0004\b\u0002\t1\fgn\u001a\u0006\u0002\u001f\u0005!!.\u0019<b\u0013\t\tBB\u0001\u0004PE*,7\r\u001e\t\u0003'qi\u0011\u0001\u0006\u0006\u0003+Y\tQa\u001d7gi)T!a\u0006\r\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005eQ\u0012\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003m\t1aY8n\u0013\tiBCA\u0004M_\u001e<\u0017N\\4\t\u0011}\u0001!\u0011!Q\u0001\n\u0001\n\u0001\u0002Z3mK\u001e\fG/\u001a\t\u0003C\u0011j\u0011A\t\u0006\u0003G\u0011\tqa\u001d;pe\u0006<W-\u0003\u0002&E\t12\u000b^8sC\u001e,7i\\7nC:$W\t_3dkR|'\u000f\u0003\u0005(\u0001\t\u0005\t\u0015!\u0003)\u0003%i\u00170\u00113ee\u0016\u001c8\u000f\u0005\u0002*U5\tA!\u0003\u0002,\t\tYaj\u001c3f\u0003\u0012$'/Z:t\u0011!i\u0003A!A!\u0002\u0013q\u0013AF2p[6\fg\u000e\u001a*fa2L7-\u0019;j_:lu\u000eZ3\u0011\u0005=\u0002T\"\u0001\u0002\n\u0005E\u0012!AF\"p[6\fg\u000e\u001a*fa2L7-\u0019;j_:lu\u000eZ3\t\u0011M\u0002!\u0011!Q\u0001\nQ\nQB\\;nE\u0016\u0014xJ\u001a(pI\u0016\u001c\bCA\u001b9\u001b\u00051$\"A\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005e2$aA%oi\"A1\b\u0001B\u0001B\u0003%A(\u0001\bde\u0016\fG/\u001a&DQ\u0006tg.\u001a7\u0011\u0007Ujt(\u0003\u0002?m\tIa)\u001e8di&|g\u000e\r\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005\u001a\tqA[4s_V\u00048/\u0003\u0002E\u0003\nA!j\u00115b]:,G\u000eC\u0003G\u0001\u0011\u0005q)\u0001\u0004=S:LGO\u0010\u000b\u0007\u0011&S5\nT'\u0011\u0005=\u0002\u0001\"B\u0010F\u0001\u0004\u0001\u0003\"B\u0014F\u0001\u0004A\u0003\"B\u0017F\u0001\u0004q\u0003\"B\u001aF\u0001\u0004!\u0004bB\u001eF!\u0003\u0005\r\u0001\u0010\u0005\u0006\u001f\u0002!\t\u0001U\u0001\u0006gR\f'\u000f\u001e\u000b\u0002#B\u0011qFU\u0005\u0003'\n\u0011\u0011CU3qY&\u001c\u0017\r^3e'R|'/Y4f\u000f\u001d)&!!A\t\u0002Y\u000bQDU3qY&\u001c\u0017\r^3e'R|'/Y4f\u0007>tg-[4ve\u0006$xN\u001d\t\u0003_]3q!\u0001\u0002\u0002\u0002#\u0005\u0001l\u0005\u0002X3B\u0011QGW\u0005\u00037Z\u0012a!\u00118z%\u00164\u0007\"\u0002$X\t\u0003iF#\u0001,\t\u000f};\u0016\u0013!C\u0001A\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIU*\u0012!\u0019\u0016\u0003y\t\\\u0013a\u0019\t\u0003I&l\u0011!\u001a\u0006\u0003M\u001e\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005!4\u0014AC1o]>$\u0018\r^5p]&\u0011!.\u001a\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class ReplicatedStorageConfigurator
implements Logging {
    private final StorageCommandExecutor delegate;
    private final NodeAddress myAddress;
    private final CommandReplicationMode commandReplicationMode;
    private final int numberOfNodes;
    private final Function0<JChannel> createJChannel;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static Function0<JChannel> $lessinit$greater$default$5() {
        return ReplicatedStorageConfigurator$.MODULE$.$lessinit$greater$default$5();
    }

    private Logger logger$lzycompute() {
        ReplicatedStorageConfigurator replicatedStorageConfigurator = this;
        synchronized (replicatedStorageConfigurator) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public ReplicatedStorage start() {
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringOps(Predef$.MODULE$.augmentString("Starting replication, mode: %s, number of nodes: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.commandReplicationMode.toString(), BoxesRunTime.boxToInteger((int)this.numberOfNodes)})));
        }
        JChannel channel = (JChannel)this.createJChannel.apply();
        channel.setDiscardOwnMessages(true);
        channel.getProtocolStack().addProtocol((Protocol)new FLUSH());
        JavaSerializationMarshaller objectMarshaller = new JavaSerializationMarshaller();
        AtomicReference<None$> masterAddressRef = new AtomicReference<None$>(None$.MODULE$);
        ClusterState clusterState = new ClusterState(this.numberOfNodes);
        MessageDispatcher messageDispatcher = new MessageDispatcher((Channel)channel, null, null);
        JGroupsReplicationMessageSender replicationMessageSender = new JGroupsReplicationMessageSender((ObjectMarshaller)objectMarshaller, this.commandReplicationMode, messageDispatcher);
        CommandResultReplicator commandResultReplicator = new CommandResultReplicator(this.delegate, replicationMessageSender);
        JGroupsReplicatedStorage replicatedStorage = new JGroupsReplicatedStorage(masterAddressRef, this.delegate, channel, commandResultReplicator, this.myAddress, clusterState);
        JGroupsRequestHandler jgroupsRequestHandler = new JGroupsRequestHandler((ObjectMarshaller)objectMarshaller, replicatedStorage, masterAddressRef, this.myAddress);
        JGroupsMembershipListener jgroupsMembershipListener = new JGroupsMembershipListener(channel, masterAddressRef, this.myAddress, replicationMessageSender, clusterState);
        JGroupsStateTransferMessageListener jgroupsStateTransferMessageListener = new JGroupsStateTransferMessageListener(this.delegate);
        messageDispatcher.setRequestHandler((RequestHandler)jgroupsRequestHandler);
        messageDispatcher.setMembershipListener((MembershipListener)jgroupsMembershipListener);
        messageDispatcher.setMessageListener((MessageListener)jgroupsStateTransferMessageListener);
        channel.connect("ElasticMQ");
        channel.getState(null, 0L);
        return replicatedStorage;
    }

    public ReplicatedStorageConfigurator(StorageCommandExecutor delegate, NodeAddress myAddress, CommandReplicationMode commandReplicationMode, int numberOfNodes, Function0<JChannel> createJChannel) {
        this.delegate = delegate;
        this.myAddress = myAddress;
        this.commandReplicationMode = commandReplicationMode;
        this.numberOfNodes = numberOfNodes;
        this.createJChannel = createJChannel;
        Logging.class.$init$((Logging)this);
    }
}

