/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.targetplatform;

import java.io.File;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.tycho.targetplatform.TargetDefinitionFile;
import org.eclipse.tycho.targetplatform.TargetResolveException;

@Component(role=TargetPlatformArtifactResolver.class)
public class TargetPlatformArtifactResolver {
    public static final String TARGET_TYPE = "target";
    @Requirement
    private RepositorySystem repositorySystem;

    public File resolveTargetFile(String groupId, String artifactId, String version, String classifier, MavenSession session, List<ArtifactRepository> remoteRepositories) throws TargetResolveException {
        Optional<File> reactorTargetFile = this.getReactorTargetFile(groupId, artifactId, version, classifier, session);
        if (reactorTargetFile.isPresent()) {
            return reactorTargetFile.get();
        }
        Artifact artifact = this.repositorySystem.createArtifactWithClassifier(groupId, artifactId, version, TARGET_TYPE, classifier);
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setArtifact(artifact);
        request.setLocalRepository(session.getLocalRepository());
        request.setRemoteRepositories(remoteRepositories);
        this.repositorySystem.resolve(request);
        if (artifact.isResolved()) {
            return artifact.getFile();
        }
        throw new TargetResolveException("Could not resolve target platform specification artifact " + artifact);
    }

    public Optional<File> getReactorTargetFile(String groupId, String artifactId, String version, String classifier, MavenSession session) throws TargetResolveException {
        for (MavenProject project : session.getProjects()) {
            if (!groupId.equals(project.getGroupId()) || !artifactId.equals(project.getArtifactId()) || !version.equals(project.getVersion())) continue;
            if (classifier == null || classifier.isBlank()) {
                File[] targetFiles = TargetDefinitionFile.listTargetFiles(project.getBasedir());
                if (targetFiles == null || targetFiles.length == 0) {
                    throw new TargetResolveException("No target definition file(s) found in project '" + project.getName() + "'.");
                }
                if (targetFiles.length == 1) {
                    return Optional.of(targetFiles[0]);
                }
                for (File targetFile : targetFiles) {
                    String baseName = FilenameUtils.getBaseName((String)targetFile.getName());
                    if (!baseName.equalsIgnoreCase(project.getArtifactId())) continue;
                    return Optional.of(targetFile);
                }
                throw new TargetResolveException("One target file must be named  '" + project.getArtifactId() + ".target' when multiple targets are present");
            }
            File target = new File(project.getBasedir(), classifier + ".target");
            if (TargetDefinitionFile.isTargetFile(target)) {
                return Optional.of(target);
            }
            throw new TargetResolveException("target definition file '" + target + "' not found in project '" + project.getName() + "'.");
        }
        return Optional.empty();
    }
}

