/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lucene;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Sets;
import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Shape;
import java.io.IOException;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.URI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.BooleanLiteral;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.GEO;
import org.eclipse.rdf4j.model.vocabulary.GEOF;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.lucene.BindingSetCollection;
import org.eclipse.rdf4j.sail.lucene.BulkUpdater;
import org.eclipse.rdf4j.sail.lucene.DistanceQuerySpec;
import org.eclipse.rdf4j.sail.lucene.DocumentDistance;
import org.eclipse.rdf4j.sail.lucene.DocumentResult;
import org.eclipse.rdf4j.sail.lucene.DocumentScore;
import org.eclipse.rdf4j.sail.lucene.GeoRelationQuerySpec;
import org.eclipse.rdf4j.sail.lucene.PropertyCache;
import org.eclipse.rdf4j.sail.lucene.QuerySpec;
import org.eclipse.rdf4j.sail.lucene.SearchDocument;
import org.eclipse.rdf4j.sail.lucene.SearchFields;
import org.eclipse.rdf4j.sail.lucene.SearchIndex;
import org.eclipse.rdf4j.sail.lucene.SearchQuery;
import org.eclipse.rdf4j.sail.lucene.SearchQueryEvaluator;
import org.eclipse.rdf4j.sail.lucene.util.MapOfListMaps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSearchIndex
implements SearchIndex {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ValueFactory vf = SimpleValueFactory.getInstance();
    private static final Set<String> REJECTED_DATATYPES = new HashSet<String>();
    protected int maxDocs;
    protected Set<String> wktFields = Collections.singleton(SearchFields.getPropertyField((URI)GEO.AS_WKT));

    @Override
    public void initialize(Properties parameters) throws Exception {
        String maxDocParam = parameters.getProperty("maxDocuments");
        this.maxDocs = maxDocParam != null ? Integer.parseInt(maxDocParam) : -1;
        String wktFieldParam = parameters.getProperty("wktFields");
        if (wktFieldParam != null) {
            this.wktFields = Sets.newHashSet((Object[])wktFieldParam.split("\\s+"));
        }
    }

    protected abstract SpatialContext getSpatialContext(String var1);

    @Override
    public boolean accept(Literal literal) {
        if (literal == null) {
            return false;
        }
        return literal.getDatatype() == null || !REJECTED_DATATYPES.contains(literal.getDatatype().stringValue());
    }

    @Override
    public boolean isGeoField(String fieldName) {
        return this.wktFields != null && this.wktFields.contains(fieldName);
    }

    @Override
    public final synchronized void addStatement(Statement statement) throws IOException {
        String contextId;
        String text = SearchFields.getLiteralPropertyValueAsString(statement);
        if (text == null) {
            return;
        }
        String field = SearchFields.getPropertyField((URI)statement.getPredicate());
        String resourceId = SearchFields.getResourceID(statement.getSubject());
        String id = SearchFields.formIdString(resourceId, contextId = SearchFields.getContextID(statement.getContext()));
        SearchDocument document = this.getDocument(id);
        if (document == null) {
            document = this.newDocument(id, resourceId, contextId);
            this.addProperty(field, text, document);
            this.addDocument(document);
        } else if (!document.hasProperty(field, text)) {
            SearchDocument newDocument = this.copyDocument(document);
            this.addProperty(field, text, newDocument);
            this.updateDocument(newDocument);
        }
    }

    @Override
    public final synchronized void removeStatement(Statement statement) throws IOException {
        String fieldName;
        String contextId;
        String text = SearchFields.getLiteralPropertyValueAsString(statement);
        if (text == null) {
            return;
        }
        String resourceId = SearchFields.getResourceID(statement.getSubject());
        String id = SearchFields.formIdString(resourceId, contextId = SearchFields.getContextID(statement.getContext()));
        SearchDocument document = this.getDocument(id);
        if (document != null && document.hasProperty(fieldName = SearchFields.getPropertyField((URI)statement.getPredicate()), text)) {
            int nrProperties = AbstractSearchIndex.countPropertyValues(document);
            if (nrProperties == 1) {
                this.deleteDocument(document);
            } else {
                SearchDocument newDocument = this.newDocument(id, resourceId, contextId);
                boolean mutated = this.copyDocument(newDocument, document, Collections.singletonMap(fieldName, Collections.singleton(text)));
                if (mutated) {
                    this.updateDocument(newDocument);
                }
            }
        }
    }

    @Override
    public final synchronized void addRemoveStatements(Collection<Statement> added, Collection<Statement> removed) throws IOException {
        MapOfListMaps<Resource, String, Statement> rsAdded = new MapOfListMaps<Resource, String, Statement>();
        MapOfListMaps<Resource, String, Statement> rsRemoved = new MapOfListMaps<Resource, String, Statement>();
        HashSet<Resource> resources = new HashSet<Resource>();
        for (Statement s : added) {
            rsAdded.add(s.getSubject(), SearchFields.getContextID(s.getContext()), s);
            resources.add(s.getSubject());
        }
        for (Statement s : removed) {
            rsRemoved.add(s.getSubject(), SearchFields.getContextID(s.getContext()), s);
            resources.add(s.getSubject());
        }
        this.logger.debug("Removing " + removed.size() + " statements, adding " + added.size() + " statements");
        BulkUpdater updater = this.newBulkUpdate();
        for (Resource resource : resources) {
            Map stmtsToRemove = rsRemoved.get(resource);
            Map stmtsToAdd = rsAdded.get(resource);
            HashSet contextsToUpdate = new HashSet(stmtsToAdd.keySet());
            contextsToUpdate.addAll(stmtsToRemove.keySet());
            HashMap<String, SearchDocument> docsByContext = new HashMap<String, SearchDocument>();
            String resourceId = SearchFields.getResourceID(resource);
            Iterable<? extends SearchDocument> documents = this.getDocuments(resourceId);
            for (SearchDocument searchDocument : documents) {
                docsByContext.put(searchDocument.getContext(), searchDocument);
            }
            for (String string : contextsToUpdate) {
                int nrProperties;
                String val;
                String id = SearchFields.formIdString(resourceId, string);
                SearchDocument document = (SearchDocument)docsByContext.get(string);
                if (document == null) {
                    document = this.newDocument(id, resourceId, string);
                    List list = stmtsToAdd.get(string);
                    if (list != null) {
                        for (Statement s : list) {
                            this.addProperty(s, document);
                        }
                    }
                    updater.add(document);
                    if (!stmtsToRemove.containsKey(string)) continue;
                    this.logger.info("Statements are marked to be removed that should not be in the store, for resource {} and context {}. Nothing done.", (Object)resource, (Object)string);
                    continue;
                }
                HashMap<String, Set<String>> removedOfResource = null;
                List removedStatements = stmtsToRemove.get(string);
                if (removedStatements != null && !removedStatements.isEmpty()) {
                    removedOfResource = new HashMap<String, Set<String>>();
                    for (Statement r : removedStatements) {
                        val = SearchFields.getLiteralPropertyValueAsString(r);
                        if (val == null) continue;
                        String field = SearchFields.getPropertyField((URI)r.getPredicate());
                        HashSet<String> removedValues = (HashSet<String>)removedOfResource.get(field);
                        if (removedValues == null) {
                            removedValues = new HashSet<String>();
                            removedOfResource.put(field, removedValues);
                        }
                        removedValues.add(val);
                    }
                }
                SearchDocument newDocument = this.newDocument(id, resourceId, string);
                boolean mutated = this.copyDocument(newDocument, document, removedOfResource);
                List addedToResource = stmtsToAdd.get(string);
                if (addedToResource != null && !addedToResource.isEmpty()) {
                    PropertyCache propertyCache = new PropertyCache(newDocument);
                    for (Statement s : addedToResource) {
                        String field;
                        val = SearchFields.getLiteralPropertyValueAsString(s);
                        if (val == null || propertyCache.hasProperty(field = SearchFields.getPropertyField((URI)s.getPredicate()), val)) continue;
                        this.addProperty(s, newDocument);
                        mutated = true;
                    }
                }
                if ((nrProperties = AbstractSearchIndex.countPropertyValues(newDocument)) > 0) {
                    if (!mutated) continue;
                    updater.update(newDocument);
                    continue;
                }
                updater.delete(document);
            }
        }
        updater.end();
    }

    private boolean copyDocument(SearchDocument newDocument, SearchDocument document, Map<String, Set<String>> removedProperties) {
        boolean mutated = false;
        for (String oldFieldName : document.getPropertyNames()) {
            newDocument.addProperty(oldFieldName);
            List<String> oldValues = document.getProperty(oldFieldName);
            if (oldValues == null) continue;
            Set<String> objectsRemoved = removedProperties != null ? removedProperties.get(oldFieldName) : null;
            for (String oldValue : oldValues) {
                if (objectsRemoved != null && objectsRemoved.contains(oldValue)) {
                    mutated = true;
                    continue;
                }
                this.addProperty(oldFieldName, oldValue, newDocument);
            }
        }
        return mutated;
    }

    private static int countPropertyValues(SearchDocument document) {
        int numValues = 0;
        Collection<String> propertyNames = document.getPropertyNames();
        for (String propertyName : propertyNames) {
            List<String> propertyValues = document.getProperty(propertyName);
            if (propertyValues == null) continue;
            numValues += propertyValues.size();
        }
        return numValues;
    }

    @Override
    public final synchronized void addDocuments(Resource subject, List<Statement> statements) throws IOException {
        String resourceId = SearchFields.getResourceID(subject);
        HashMultimap stmtsByContextId = HashMultimap.create();
        for (Statement statement : statements) {
            String contextId = SearchFields.getContextID(statement.getContext());
            stmtsByContextId.put((Object)contextId, (Object)statement);
        }
        BulkUpdater batch = this.newBulkUpdate();
        for (Map.Entry entry : stmtsByContextId.asMap().entrySet()) {
            String id = SearchFields.formIdString(resourceId, (String)entry.getKey());
            SearchDocument document = this.newDocument(id, resourceId, (String)entry.getKey());
            for (Statement stmt : (Collection)entry.getValue()) {
                this.addProperty(stmt, document);
            }
            batch.add(document);
        }
        batch.end();
    }

    private void addProperty(Statement statement, SearchDocument document) {
        String value = SearchFields.getLiteralPropertyValueAsString(statement);
        if (value == null) {
            return;
        }
        String field = SearchFields.getPropertyField((URI)statement.getPredicate());
        this.addProperty(field, value, document);
    }

    private void addProperty(String field, String value, SearchDocument document) {
        if (this.isGeoField(field)) {
            document.addGeoProperty(field, value);
        } else {
            document.addProperty(field, value);
        }
    }

    @Override
    @Deprecated
    public Collection<BindingSet> evaluate(QuerySpec query) throws SailException {
        Iterable<? extends DocumentScore> result = this.evaluateQuery(query);
        return this.generateBindingSets(query, result);
    }

    @Override
    public final Collection<BindingSet> evaluate(SearchQueryEvaluator evaluator) throws SailException {
        if (evaluator instanceof QuerySpec) {
            QuerySpec query = (QuerySpec)evaluator;
            Iterable<? extends DocumentScore> result = this.evaluateQuery(query);
            return this.generateBindingSets(query, result);
        }
        if (evaluator instanceof DistanceQuerySpec) {
            DistanceQuerySpec query = (DistanceQuerySpec)evaluator;
            Iterable<? extends DocumentDistance> result = this.evaluateQuery(query);
            return this.generateBindingSets(query, result);
        }
        if (evaluator instanceof GeoRelationQuerySpec) {
            GeoRelationQuerySpec query = (GeoRelationQuerySpec)evaluator;
            Iterable<? extends DocumentResult> result = this.evaluateQuery(query);
            return this.generateBindingSets(query, result);
        }
        throw new IllegalArgumentException("Unsupported " + SearchQueryEvaluator.class.getSimpleName() + ": " + evaluator.getClass().getName());
    }

    private Iterable<? extends DocumentScore> evaluateQuery(QuerySpec query) {
        Iterable<? extends DocumentScore> hits = null;
        try {
            String sQuery = query.getQueryString();
            if (!sQuery.isEmpty()) {
                boolean highlight = query.getSnippetVariableName() != null || query.getPropertyVariableName() != null;
                hits = this.query(query.getSubject(), query.getQueryString(), (URI)query.getPropertyURI(), highlight);
            } else {
                hits = null;
            }
        }
        catch (Exception e) {
            this.logger.error("There was a problem evaluating query '" + query.getQueryString() + "' for property '" + query.getPropertyURI() + "!", (Throwable)e);
        }
        return hits;
    }

    private Collection<BindingSet> generateBindingSets(QuerySpec query, Iterable<? extends DocumentScore> hits) throws SailException {
        String propertyVar;
        String snippetVar;
        String scoreVar;
        LinkedHashSet<BindingSet> bindingSets = new LinkedHashSet<BindingSet>();
        HashSet<String> bindingNames = new HashSet<String>();
        String matchVar = query.getMatchesVariableName();
        if (matchVar != null) {
            bindingNames.add(matchVar);
        }
        if ((scoreVar = query.getScoreVariableName()) != null) {
            bindingNames.add(scoreVar);
        }
        if ((snippetVar = query.getSnippetVariableName()) != null) {
            bindingNames.add(snippetVar);
        }
        if ((propertyVar = query.getPropertyVariableName()) != null && query.getPropertyURI() == null) {
            bindingNames.add(propertyVar);
        }
        if (hits != null) {
            for (DocumentScore documentScore : hits) {
                QueryBindingSet derivedBindings = new QueryBindingSet();
                SearchDocument doc = documentScore.getDocument();
                if (doc == null) continue;
                float score = documentScore.getScore();
                if (matchVar != null) {
                    Resource resource = this.getResource(doc);
                    derivedBindings.addBinding(matchVar, (Value)resource);
                }
                if (scoreVar != null && score > 0.0f) {
                    derivedBindings.addBinding(scoreVar, (Value)SearchFields.scoreToLiteral(score));
                }
                if (snippetVar != null || propertyVar != null) {
                    if (documentScore.isHighlighted()) {
                        Collection<String> fields;
                        if (query.getPropertyURI() != null) {
                            String fieldname = SearchFields.getPropertyField((URI)query.getPropertyURI());
                            fields = Collections.singleton(fieldname);
                        } else {
                            fields = doc.getPropertyNames();
                        }
                        for (String field : fields) {
                            Iterable<String> snippets = documentScore.getSnippets(field);
                            if (snippets == null) continue;
                            for (String snippet : snippets) {
                                if (snippet == null || snippet.isEmpty()) continue;
                                QueryBindingSet snippetBindings = new QueryBindingSet((BindingSet)derivedBindings);
                                if (snippetVar != null) {
                                    snippetBindings.addBinding(snippetVar, (Value)this.vf.createLiteral(snippet));
                                }
                                if (propertyVar != null && query.getPropertyURI() == null) {
                                    snippetBindings.addBinding(propertyVar, (Value)this.vf.createIRI(field));
                                }
                                bindingSets.add((BindingSet)snippetBindings);
                            }
                        }
                        continue;
                    }
                    this.logger.warn("Lucene Query requests snippet, but no highlighter was generated for it, no snippets will be generated!\n{}", (Object)query);
                    bindingSets.add((BindingSet)derivedBindings);
                    continue;
                }
                bindingSets.add((BindingSet)derivedBindings);
            }
        }
        return new BindingSetCollection(bindingNames, bindingSets);
    }

    private Iterable<? extends DocumentDistance> evaluateQuery(DistanceQuerySpec query) {
        Iterable<? extends DocumentDistance> hits = null;
        Literal from = query.getFrom();
        double distance = query.getDistance();
        IRI units = query.getUnits();
        IRI geoProperty = query.getGeoProperty();
        try {
            if (!GEO.WKT_LITERAL.equals((Object)from.getDatatype())) {
                throw new MalformedQueryException("Unsupported datatype: " + from.getDatatype());
            }
            Shape shape = this.parseQueryShape(SearchFields.getPropertyField((URI)geoProperty), from.getLabel());
            if (!(shape instanceof Point)) {
                throw new MalformedQueryException("Geometry literal is not a point: " + from.getLabel());
            }
            Point p = (Point)shape;
            hits = this.geoQuery((URI)geoProperty, p, (URI)units, distance, query.getDistanceVar(), query.getContextVar());
        }
        catch (Exception e) {
            this.logger.error("There was a problem evaluating distance query 'within " + distance + AbstractSearchIndex.getUnitSymbol(units) + " of " + from.getLabel() + "'!", (Throwable)e);
        }
        return hits;
    }

    private static String getUnitSymbol(IRI units) {
        if (GEOF.UOM_METRE.equals((Object)units)) {
            return "m";
        }
        return "";
    }

    private Collection<BindingSet> generateBindingSets(DistanceQuerySpec query, Iterable<? extends DocumentDistance> hits) throws SailException {
        Var contextVar;
        String distanceVar;
        String geoVar;
        LinkedHashSet<BindingSet> bindingSets = new LinkedHashSet<BindingSet>();
        HashSet<String> bindingNames = new HashSet<String>();
        String subjVar = query.getSubjectVar();
        if (subjVar != null) {
            bindingNames.add(subjVar);
        }
        if ((geoVar = query.getGeoVar()) != null) {
            bindingNames.add(geoVar);
        }
        if ((distanceVar = query.getDistanceVar()) != null) {
            bindingNames.add(distanceVar);
        }
        if ((contextVar = query.getContextVar()) != null && !contextVar.hasValue()) {
            bindingNames.add(contextVar.getName());
        }
        if (hits != null) {
            double maxDistance = query.getDistance();
            for (DocumentDistance documentDistance : hits) {
                SearchDocument doc = documentDistance.getDocument();
                if (doc == null) continue;
                List<String> geometries = doc.getProperty(SearchFields.getPropertyField((URI)query.getGeoProperty()));
                for (String geometry : geometries) {
                    Resource ctx;
                    double distance = documentDistance.getDistance();
                    if (!(distance < maxDistance)) continue;
                    QueryBindingSet derivedBindings = new QueryBindingSet();
                    if (subjVar != null) {
                        Resource resource = this.getResource(doc);
                        derivedBindings.addBinding(subjVar, (Value)resource);
                    }
                    if (contextVar != null && !contextVar.hasValue() && (ctx = SearchFields.createContext(doc.getContext())) != null) {
                        derivedBindings.addBinding(contextVar.getName(), (Value)ctx);
                    }
                    if (geoVar != null) {
                        derivedBindings.addBinding(geoVar, (Value)SearchFields.wktToLiteral(geometry));
                    }
                    if (distanceVar != null) {
                        derivedBindings.addBinding(distanceVar, (Value)SearchFields.distanceToLiteral(distance));
                    }
                    bindingSets.add((BindingSet)derivedBindings);
                }
            }
        }
        return new BindingSetCollection(bindingNames, bindingSets);
    }

    private Iterable<? extends DocumentResult> evaluateQuery(GeoRelationQuerySpec query) {
        Iterable<? extends DocumentResult> hits = null;
        Literal qgeom = query.getQueryGeometry();
        IRI geoProperty = query.getGeoProperty();
        try {
            if (!GEO.WKT_LITERAL.equals((Object)qgeom.getDatatype())) {
                throw new MalformedQueryException("Unsupported datatype: " + qgeom.getDatatype());
            }
            Shape qshape = this.parseQueryShape(SearchFields.getPropertyField((URI)geoProperty), qgeom.getLabel());
            hits = this.geoRelationQuery(query.getRelation(), (URI)geoProperty, qshape, query.getContextVar());
        }
        catch (Exception e) {
            this.logger.error("There was a problem evaluating spatial relation query '" + query.getRelation() + " " + qgeom.getLabel() + "'!", (Throwable)e);
        }
        return hits;
    }

    private Collection<BindingSet> generateBindingSets(GeoRelationQuerySpec query, Iterable<? extends DocumentResult> hits) throws SailException {
        Var contextVar;
        String fVar;
        String geoVar;
        LinkedHashSet<BindingSet> bindingSets = new LinkedHashSet<BindingSet>();
        HashSet<String> bindingNames = new HashSet<String>();
        String subjVar = query.getSubjectVar();
        if (subjVar != null) {
            bindingNames.add(subjVar);
        }
        if ((geoVar = query.getGeoVar()) != null) {
            bindingNames.add(geoVar);
        }
        if ((fVar = query.getFunctionValueVar()) != null) {
            bindingNames.add(fVar);
        }
        if ((contextVar = query.getContextVar()) != null && !contextVar.hasValue()) {
            bindingNames.add(contextVar.getName());
        }
        if (hits != null) {
            for (DocumentResult documentResult : hits) {
                SearchDocument doc = documentResult.getDocument();
                if (doc == null) continue;
                List<String> geometries = doc.getProperty(SearchFields.getPropertyField((URI)query.getGeoProperty()));
                for (String geometry : geometries) {
                    Resource ctx;
                    QueryBindingSet derivedBindings = new QueryBindingSet();
                    if (subjVar != null) {
                        Resource resource = this.getResource(doc);
                        derivedBindings.addBinding(subjVar, (Value)resource);
                    }
                    if (contextVar != null && !contextVar.hasValue() && (ctx = SearchFields.createContext(doc.getContext())) != null) {
                        derivedBindings.addBinding(contextVar.getName(), (Value)ctx);
                    }
                    if (geoVar != null) {
                        derivedBindings.addBinding(geoVar, (Value)SearchFields.wktToLiteral(geometry));
                    }
                    if (fVar != null) {
                        derivedBindings.addBinding(fVar, (Value)BooleanLiteral.TRUE);
                    }
                    bindingSets.add((BindingSet)derivedBindings);
                }
            }
        }
        return new BindingSetCollection(bindingNames, bindingSets);
    }

    protected Shape parseQueryShape(String property, String value) throws ParseException {
        return this.getSpatialContext(property).readShapeFromWkt(value);
    }

    protected Resource getResource(SearchDocument document) {
        return SearchFields.createResource(document.getResource());
    }

    protected abstract SearchDocument getDocument(String var1) throws IOException;

    protected abstract Iterable<? extends SearchDocument> getDocuments(String var1) throws IOException;

    protected abstract SearchDocument newDocument(String var1, String var2, String var3);

    protected abstract SearchDocument copyDocument(SearchDocument var1);

    protected abstract void addDocument(SearchDocument var1) throws IOException;

    protected abstract void updateDocument(SearchDocument var1) throws IOException;

    protected abstract void deleteDocument(SearchDocument var1) throws IOException;

    @Deprecated
    protected abstract SearchQuery parseQuery(String var1, URI var2) throws MalformedQueryException;

    protected abstract Iterable<? extends DocumentScore> query(Resource var1, String var2, URI var3, boolean var4) throws MalformedQueryException, IOException;

    protected abstract Iterable<? extends DocumentDistance> geoQuery(URI var1, Point var2, URI var3, double var4, String var6, Var var7) throws MalformedQueryException, IOException;

    protected abstract Iterable<? extends DocumentResult> geoRelationQuery(String var1, URI var2, Shape var3, Var var4) throws MalformedQueryException, IOException;

    protected abstract BulkUpdater newBulkUpdate();

    static {
        REJECTED_DATATYPES.add("http://www.w3.org/2001/XMLSchema#float");
    }
}

