/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.extensiblestore;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.CloseableIteratorIteration;
import org.eclipse.rdf4j.common.transaction.IsolationLevel;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.base.SailDataset;
import org.eclipse.rdf4j.sail.base.SailSink;
import org.eclipse.rdf4j.sail.base.SailSource;
import org.eclipse.rdf4j.sail.extensiblestore.DataStructureInterface;
import org.eclipse.rdf4j.sail.extensiblestore.NamespaceStoreInterface;
import org.eclipse.rdf4j.sail.extensiblestore.ReadCommittedWrapper;
import org.eclipse.rdf4j.sail.extensiblestore.valuefactory.ExtensibleStatementHelper;

@Experimental
class ExtensibleSailSource
implements SailSource {
    private final DataStructureInterface dataStructure;
    private final NamespaceStoreInterface namespaceStore;
    private final boolean inferred;
    private final ExtensibleStatementHelper extensibleStatementHelper;

    public ExtensibleSailSource(DataStructureInterface dataStructure, NamespaceStoreInterface namespaceStore, boolean inferred, ExtensibleStatementHelper extensibleStatementHelper) {
        this.dataStructure = dataStructure;
        this.namespaceStore = namespaceStore;
        this.inferred = inferred;
        this.extensibleStatementHelper = extensibleStatementHelper;
    }

    public void close() throws SailException {
    }

    public SailSource fork() {
        return new ExtensibleSailSource(new ReadCommittedWrapper(this.dataStructure), this.namespaceStore, this.inferred, this.extensibleStatementHelper);
    }

    public SailSink sink(IsolationLevel level) throws SailException {
        return new SailSink(){

            public void prepare() throws SailException {
            }

            public void flush() throws SailException {
                ExtensibleSailSource.this.dataStructure.flushForReading();
            }

            public synchronized void setNamespace(String prefix, String name) throws SailException {
                ExtensibleSailSource.this.namespaceStore.setNamespace(prefix, name);
            }

            public synchronized void removeNamespace(String prefix) throws SailException {
                ExtensibleSailSource.this.namespaceStore.removeNamespace(prefix);
            }

            public synchronized void clearNamespaces() throws SailException {
                ExtensibleSailSource.this.namespaceStore.clear();
            }

            public void clear(Resource ... contexts) throws SailException {
                ExtensibleSailSource.this.dataStructure.clear(ExtensibleSailSource.this.inferred, contexts);
            }

            public void observe(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
                throw new RuntimeException("Unsupported operation");
            }

            public void approve(Resource subj, IRI pred, Value obj, Resource ctx) throws SailException {
                Statement statement = SimpleValueFactory.getInstance().createStatement(subj, pred, obj, ctx);
                ExtensibleSailSource.this.dataStructure.addStatement(ExtensibleSailSource.this.extensibleStatementHelper.fromStatement(statement, ExtensibleSailSource.this.inferred));
            }

            public void approve(Statement statement) throws SailException {
                ExtensibleSailSource.this.dataStructure.addStatement(ExtensibleSailSource.this.extensibleStatementHelper.fromStatement(statement, ExtensibleSailSource.this.inferred));
            }

            public void deprecate(Resource subj, IRI pred, Value obj, Resource ctx) throws SailException {
                throw new IllegalStateException("Unsupported operation. Use deprecate(Statement statement) instead!");
            }

            public void deprecate(Statement statement) throws SailException {
                ExtensibleSailSource.this.dataStructure.removeStatement(ExtensibleSailSource.this.extensibleStatementHelper.fromStatement(statement, ExtensibleSailSource.this.inferred));
            }

            public boolean deprecateByQuery(Resource subj, IRI pred, Value obj, Resource[] contexts) {
                return ExtensibleSailSource.this.dataStructure.removeStatementsByQuery(subj, pred, obj, ExtensibleSailSource.this.inferred, contexts);
            }

            public void close() throws SailException {
            }
        };
    }

    public SailDataset dataset(IsolationLevel level) throws SailException {
        return new SailDataset(){

            public void close() throws SailException {
            }

            public String getNamespace(String prefix) throws SailException {
                return ExtensibleSailSource.this.namespaceStore.getNamespace(prefix);
            }

            public CloseableIteration<? extends Namespace, SailException> getNamespaces() {
                return new CloseableIteratorIteration(ExtensibleSailSource.this.namespaceStore.iterator());
            }

            public CloseableIteration<? extends Resource, SailException> getContextIDs() throws SailException {
                return new CloseableIteration<Resource, SailException>(){
                    final CloseableIteration<? extends Statement, SailException> statements;
                    final Set<Resource> contexts;
                    Resource next;
                    {
                        this.statements = this.getStatements(null, null, null, new Resource[0]);
                        this.contexts = new HashSet<Resource>();
                        this.next = this.internalNext();
                    }

                    private Resource internalNext() {
                        while (this.statements.hasNext()) {
                            Statement next = (Statement)this.statements.next();
                            if (this.contexts.contains(next.getContext())) continue;
                            this.contexts.add(next.getContext());
                            return next.getContext();
                        }
                        return null;
                    }

                    public boolean hasNext() {
                        if (this.next == null) {
                            this.next = this.internalNext();
                        }
                        return this.next != null;
                    }

                    public Resource next() {
                        if (this.next == null) {
                            this.next = this.internalNext();
                        }
                        Resource temp = this.next;
                        this.next = null;
                        return temp;
                    }

                    public void remove() {
                    }

                    public void close() {
                        this.statements.close();
                    }
                };
            }

            public CloseableIteration<? extends Statement, SailException> getStatements(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
                return ExtensibleSailSource.this.dataStructure.getStatements(subj, pred, obj, ExtensibleSailSource.this.inferred, contexts);
            }
        };
    }

    public void prepare() throws SailException {
    }

    public void flush() throws SailException {
        this.dataStructure.flushForCommit();
    }

    public void init() {
        this.dataStructure.init();
    }
}

