/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.testsuite.rio;

import java.io.InputStream;
import java.net.MalformedURLException;
import junit.framework.TestCase;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.rio.ParseErrorListener;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.helpers.ParseErrorCollector;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;
import org.eclipse.rdf4j.testsuite.rio.FailureMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NegativeParserTest
extends TestCase {
    private final String inputURL;
    private final String baseURL;
    private final RDFParser targetParser;
    protected IRI testUri;
    protected FailureMode failureMode;
    protected boolean didIgnoreFailure;
    private static final Logger logger = LoggerFactory.getLogger(NegativeParserTest.class);

    public NegativeParserTest(IRI testUri, String caseURI, String inputURL, String baseURL, RDFParser targetParser, FailureMode failureMode) throws MalformedURLException {
        super(caseURI);
        this.testUri = testUri;
        this.inputURL = inputURL;
        this.baseURL = baseURL;
        this.targetParser = targetParser;
        this.failureMode = failureMode;
    }

    protected void runTest() {
        ParseErrorCollector el = new ParseErrorCollector();
        try {
            this.targetParser.setRDFHandler((RDFHandler)new StatementCollector());
            InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(this.inputURL);
            NegativeParserTest.assertNotNull((String)("Test resource was not found: inputURL=" + this.inputURL), (Object)in);
            logger.debug("test: " + this.inputURL);
            this.targetParser.setParseErrorListener((ParseErrorListener)el);
            this.targetParser.parse(in, this.baseURL);
            in.close();
            if (this.failureMode.ignoreFailure()) {
                this.didIgnoreFailure = true;
                logger.warn("Ignoring Negative Parser Test that does not report an expected error: " + this.inputURL);
            } else {
                this.didIgnoreFailure = false;
                NegativeParserTest.fail((String)"Parser parses erroneous data without reporting errors");
            }
        }
        catch (RDFParseException in) {
        }
        catch (Exception e) {
            NegativeParserTest.fail((String)("Error: " + e.getMessage()));
        }
    }
}

