/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.watcher.api;

import org.eclipse.jkube.kit.build.service.docker.WatchService;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.config.image.build.JKubeConfiguration;
import org.eclipse.jkube.kit.config.resource.ProcessorConfig;
import org.eclipse.jkube.kit.config.service.JKubeServiceHub;

public class WatcherContext {
    private ProcessorConfig config;
    private KitLogger logger;
    private KitLogger newPodLogger;
    private KitLogger oldPodLogger;
    private boolean useProjectClasspath;
    private WatchService.WatchContext watchContext;
    private JKubeConfiguration buildContext;
    private JKubeServiceHub jKubeServiceHub;

    public static WatcherContextBuilder builder() {
        return new WatcherContextBuilder();
    }

    public WatcherContext(ProcessorConfig config, KitLogger logger, KitLogger newPodLogger, KitLogger oldPodLogger, boolean useProjectClasspath, WatchService.WatchContext watchContext, JKubeConfiguration buildContext, JKubeServiceHub jKubeServiceHub) {
        this.config = config;
        this.logger = logger;
        this.newPodLogger = newPodLogger;
        this.oldPodLogger = oldPodLogger;
        this.useProjectClasspath = useProjectClasspath;
        this.watchContext = watchContext;
        this.buildContext = buildContext;
        this.jKubeServiceHub = jKubeServiceHub;
    }

    private WatcherContext() {
    }

    public ProcessorConfig getConfig() {
        return this.config;
    }

    public KitLogger getLogger() {
        return this.logger;
    }

    public KitLogger getNewPodLogger() {
        return this.newPodLogger;
    }

    public KitLogger getOldPodLogger() {
        return this.oldPodLogger;
    }

    public boolean isUseProjectClasspath() {
        return this.useProjectClasspath;
    }

    public WatchService.WatchContext getWatchContext() {
        return this.watchContext;
    }

    public JKubeConfiguration getBuildContext() {
        return this.buildContext;
    }

    public JKubeServiceHub getJKubeServiceHub() {
        return this.jKubeServiceHub;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WatcherContext)) {
            return false;
        }
        WatcherContext other = (WatcherContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ProcessorConfig this$config = this.getConfig();
        ProcessorConfig other$config = other.getConfig();
        if (this$config == null ? other$config != null : !this$config.equals(other$config)) {
            return false;
        }
        KitLogger this$logger = this.getLogger();
        KitLogger other$logger = other.getLogger();
        if (this$logger == null ? other$logger != null : !this$logger.equals(other$logger)) {
            return false;
        }
        KitLogger this$newPodLogger = this.getNewPodLogger();
        KitLogger other$newPodLogger = other.getNewPodLogger();
        if (this$newPodLogger == null ? other$newPodLogger != null : !this$newPodLogger.equals(other$newPodLogger)) {
            return false;
        }
        KitLogger this$oldPodLogger = this.getOldPodLogger();
        KitLogger other$oldPodLogger = other.getOldPodLogger();
        if (this$oldPodLogger == null ? other$oldPodLogger != null : !this$oldPodLogger.equals(other$oldPodLogger)) {
            return false;
        }
        if (this.isUseProjectClasspath() != other.isUseProjectClasspath()) {
            return false;
        }
        WatchService.WatchContext this$watchContext = this.getWatchContext();
        WatchService.WatchContext other$watchContext = other.getWatchContext();
        if (this$watchContext == null ? other$watchContext != null : !this$watchContext.equals(other$watchContext)) {
            return false;
        }
        JKubeConfiguration this$buildContext = this.getBuildContext();
        JKubeConfiguration other$buildContext = other.getBuildContext();
        if (this$buildContext == null ? other$buildContext != null : !this$buildContext.equals(other$buildContext)) {
            return false;
        }
        JKubeServiceHub this$jKubeServiceHub = this.getJKubeServiceHub();
        JKubeServiceHub other$jKubeServiceHub = other.getJKubeServiceHub();
        return !(this$jKubeServiceHub == null ? other$jKubeServiceHub != null : !this$jKubeServiceHub.equals(other$jKubeServiceHub));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WatcherContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ProcessorConfig $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : $config.hashCode());
        KitLogger $logger = this.getLogger();
        result = result * 59 + ($logger == null ? 43 : $logger.hashCode());
        KitLogger $newPodLogger = this.getNewPodLogger();
        result = result * 59 + ($newPodLogger == null ? 43 : $newPodLogger.hashCode());
        KitLogger $oldPodLogger = this.getOldPodLogger();
        result = result * 59 + ($oldPodLogger == null ? 43 : $oldPodLogger.hashCode());
        result = result * 59 + (this.isUseProjectClasspath() ? 79 : 97);
        WatchService.WatchContext $watchContext = this.getWatchContext();
        result = result * 59 + ($watchContext == null ? 43 : $watchContext.hashCode());
        JKubeConfiguration $buildContext = this.getBuildContext();
        result = result * 59 + ($buildContext == null ? 43 : $buildContext.hashCode());
        JKubeServiceHub $jKubeServiceHub = this.getJKubeServiceHub();
        result = result * 59 + ($jKubeServiceHub == null ? 43 : $jKubeServiceHub.hashCode());
        return result;
    }

    public static class WatcherContextBuilder {
        private ProcessorConfig config;
        private KitLogger logger;
        private KitLogger newPodLogger;
        private KitLogger oldPodLogger;
        private boolean useProjectClasspath;
        private WatchService.WatchContext watchContext;
        private JKubeConfiguration buildContext;
        private JKubeServiceHub jKubeServiceHub;

        WatcherContextBuilder() {
        }

        public WatcherContextBuilder config(ProcessorConfig config) {
            this.config = config;
            return this;
        }

        public WatcherContextBuilder logger(KitLogger logger) {
            this.logger = logger;
            return this;
        }

        public WatcherContextBuilder newPodLogger(KitLogger newPodLogger) {
            this.newPodLogger = newPodLogger;
            return this;
        }

        public WatcherContextBuilder oldPodLogger(KitLogger oldPodLogger) {
            this.oldPodLogger = oldPodLogger;
            return this;
        }

        public WatcherContextBuilder useProjectClasspath(boolean useProjectClasspath) {
            this.useProjectClasspath = useProjectClasspath;
            return this;
        }

        public WatcherContextBuilder watchContext(WatchService.WatchContext watchContext) {
            this.watchContext = watchContext;
            return this;
        }

        public WatcherContextBuilder buildContext(JKubeConfiguration buildContext) {
            this.buildContext = buildContext;
            return this;
        }

        public WatcherContextBuilder jKubeServiceHub(JKubeServiceHub jKubeServiceHub) {
            this.jKubeServiceHub = jKubeServiceHub;
            return this;
        }

        public WatcherContext build() {
            return new WatcherContext(this.config, this.logger, this.newPodLogger, this.oldPodLogger, this.useProjectClasspath, this.watchContext, this.buildContext, this.jKubeServiceHub);
        }

        public String toString() {
            return "WatcherContext.WatcherContextBuilder(config=" + this.config + ", logger=" + this.logger + ", newPodLogger=" + this.newPodLogger + ", oldPodLogger=" + this.oldPodLogger + ", useProjectClasspath=" + this.useProjectClasspath + ", watchContext=" + this.watchContext + ", buildContext=" + this.buildContext + ", jKubeServiceHub=" + this.jKubeServiceHub + ")";
        }
    }
}

