/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.resource;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.ResourceFileType;
import org.eclipse.jkube.kit.config.resource.ResourceConfig;
import org.eclipse.jkube.kit.config.resource.ResourceService;

public class ResourceServiceConfig {
    private JavaProject project;
    private List<File> resourceDirs;
    private File targetDir;
    private ResourceFileType resourceFileType;
    private ResourceConfig resourceConfig;
    private ResourceService.ResourceFileProcessor resourceFilesProcessor;
    private boolean interpolateTemplateParameters;

    public static ResourceServiceConfigBuilder builder() {
        return new ResourceServiceConfigBuilder();
    }

    public ResourceServiceConfigBuilder toBuilder() {
        ResourceServiceConfigBuilder builder = new ResourceServiceConfigBuilder().project(this.project).targetDir(this.targetDir).resourceFileType(this.resourceFileType).resourceConfig(this.resourceConfig).resourceFilesProcessor(this.resourceFilesProcessor).interpolateTemplateParameters(this.interpolateTemplateParameters);
        if (this.resourceDirs != null) {
            builder.resourceDirs(this.resourceDirs);
        }
        return builder;
    }

    public ResourceServiceConfig(JavaProject project, List<File> resourceDirs, File targetDir, ResourceFileType resourceFileType, ResourceConfig resourceConfig, ResourceService.ResourceFileProcessor resourceFilesProcessor, boolean interpolateTemplateParameters) {
        this.project = project;
        this.resourceDirs = resourceDirs;
        this.targetDir = targetDir;
        this.resourceFileType = resourceFileType;
        this.resourceConfig = resourceConfig;
        this.resourceFilesProcessor = resourceFilesProcessor;
        this.interpolateTemplateParameters = interpolateTemplateParameters;
    }

    public ResourceServiceConfig() {
    }

    public JavaProject getProject() {
        return this.project;
    }

    public List<File> getResourceDirs() {
        return this.resourceDirs;
    }

    public File getTargetDir() {
        return this.targetDir;
    }

    public ResourceFileType getResourceFileType() {
        return this.resourceFileType;
    }

    public ResourceConfig getResourceConfig() {
        return this.resourceConfig;
    }

    public ResourceService.ResourceFileProcessor getResourceFilesProcessor() {
        return this.resourceFilesProcessor;
    }

    public boolean isInterpolateTemplateParameters() {
        return this.interpolateTemplateParameters;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourceServiceConfig)) {
            return false;
        }
        ResourceServiceConfig other = (ResourceServiceConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isInterpolateTemplateParameters() != other.isInterpolateTemplateParameters()) {
            return false;
        }
        JavaProject this$project = this.getProject();
        JavaProject other$project = other.getProject();
        if (this$project == null ? other$project != null : !this$project.equals(other$project)) {
            return false;
        }
        List<File> this$resourceDirs = this.getResourceDirs();
        List<File> other$resourceDirs = other.getResourceDirs();
        if (this$resourceDirs == null ? other$resourceDirs != null : !((Object)this$resourceDirs).equals(other$resourceDirs)) {
            return false;
        }
        File this$targetDir = this.getTargetDir();
        File other$targetDir = other.getTargetDir();
        if (this$targetDir == null ? other$targetDir != null : !((Object)this$targetDir).equals(other$targetDir)) {
            return false;
        }
        ResourceFileType this$resourceFileType = this.getResourceFileType();
        ResourceFileType other$resourceFileType = other.getResourceFileType();
        if (this$resourceFileType == null ? other$resourceFileType != null : !this$resourceFileType.equals(other$resourceFileType)) {
            return false;
        }
        ResourceConfig this$resourceConfig = this.getResourceConfig();
        ResourceConfig other$resourceConfig = other.getResourceConfig();
        if (this$resourceConfig == null ? other$resourceConfig != null : !((Object)this$resourceConfig).equals(other$resourceConfig)) {
            return false;
        }
        ResourceService.ResourceFileProcessor this$resourceFilesProcessor = this.getResourceFilesProcessor();
        ResourceService.ResourceFileProcessor other$resourceFilesProcessor = other.getResourceFilesProcessor();
        return !(this$resourceFilesProcessor == null ? other$resourceFilesProcessor != null : !this$resourceFilesProcessor.equals(other$resourceFilesProcessor));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResourceServiceConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isInterpolateTemplateParameters() ? 79 : 97);
        JavaProject $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : $project.hashCode());
        List<File> $resourceDirs = this.getResourceDirs();
        result = result * 59 + ($resourceDirs == null ? 43 : ((Object)$resourceDirs).hashCode());
        File $targetDir = this.getTargetDir();
        result = result * 59 + ($targetDir == null ? 43 : ((Object)$targetDir).hashCode());
        ResourceFileType $resourceFileType = this.getResourceFileType();
        result = result * 59 + ($resourceFileType == null ? 43 : $resourceFileType.hashCode());
        ResourceConfig $resourceConfig = this.getResourceConfig();
        result = result * 59 + ($resourceConfig == null ? 43 : ((Object)$resourceConfig).hashCode());
        ResourceService.ResourceFileProcessor $resourceFilesProcessor = this.getResourceFilesProcessor();
        result = result * 59 + ($resourceFilesProcessor == null ? 43 : $resourceFilesProcessor.hashCode());
        return result;
    }

    public static class ResourceServiceConfigBuilder {
        private JavaProject project;
        private ArrayList<File> resourceDirs;
        private File targetDir;
        private ResourceFileType resourceFileType;
        private ResourceConfig resourceConfig;
        private ResourceService.ResourceFileProcessor resourceFilesProcessor;
        private boolean interpolateTemplateParameters;

        ResourceServiceConfigBuilder() {
        }

        public ResourceServiceConfigBuilder project(JavaProject project) {
            this.project = project;
            return this;
        }

        public ResourceServiceConfigBuilder resourceDir(File resourceDir) {
            if (this.resourceDirs == null) {
                this.resourceDirs = new ArrayList();
            }
            this.resourceDirs.add(resourceDir);
            return this;
        }

        public ResourceServiceConfigBuilder resourceDirs(Collection<? extends File> resourceDirs) {
            if (resourceDirs == null) {
                throw new NullPointerException("resourceDirs cannot be null");
            }
            if (this.resourceDirs == null) {
                this.resourceDirs = new ArrayList();
            }
            this.resourceDirs.addAll(resourceDirs);
            return this;
        }

        public ResourceServiceConfigBuilder clearResourceDirs() {
            if (this.resourceDirs != null) {
                this.resourceDirs.clear();
            }
            return this;
        }

        public ResourceServiceConfigBuilder targetDir(File targetDir) {
            this.targetDir = targetDir;
            return this;
        }

        public ResourceServiceConfigBuilder resourceFileType(ResourceFileType resourceFileType) {
            this.resourceFileType = resourceFileType;
            return this;
        }

        public ResourceServiceConfigBuilder resourceConfig(ResourceConfig resourceConfig) {
            this.resourceConfig = resourceConfig;
            return this;
        }

        public ResourceServiceConfigBuilder resourceFilesProcessor(ResourceService.ResourceFileProcessor resourceFilesProcessor) {
            this.resourceFilesProcessor = resourceFilesProcessor;
            return this;
        }

        public ResourceServiceConfigBuilder interpolateTemplateParameters(boolean interpolateTemplateParameters) {
            this.interpolateTemplateParameters = interpolateTemplateParameters;
            return this;
        }

        public ResourceServiceConfig build() {
            List<File> resourceDirs;
            switch (this.resourceDirs == null ? 0 : this.resourceDirs.size()) {
                case 0: {
                    resourceDirs = Collections.emptyList();
                    break;
                }
                case 1: {
                    resourceDirs = Collections.singletonList(this.resourceDirs.get(0));
                    break;
                }
                default: {
                    resourceDirs = Collections.unmodifiableList(new ArrayList<File>(this.resourceDirs));
                }
            }
            return new ResourceServiceConfig(this.project, resourceDirs, this.targetDir, this.resourceFileType, this.resourceConfig, this.resourceFilesProcessor, this.interpolateTemplateParameters);
        }

        public String toString() {
            return "ResourceServiceConfig.ResourceServiceConfigBuilder(project=" + this.project + ", resourceDirs=" + this.resourceDirs + ", targetDir=" + this.targetDir + ", resourceFileType=" + this.resourceFileType + ", resourceConfig=" + this.resourceConfig + ", resourceFilesProcessor=" + this.resourceFilesProcessor + ", interpolateTemplateParameters=" + this.interpolateTemplateParameters + ")";
        }
    }
}

