/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.version;

import java.io.IOException;
import java.util.HashMap;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.jetty.toolchain.version.AbstractVersionMojo;
import org.eclipse.jetty.toolchain.version.Release;
import org.eclipse.jetty.toolchain.version.VersionPattern;
import org.eclipse.jetty.toolchain.version.VersionText;
import org.eclipse.jetty.toolchain.version.issues.GitHubIssueResolver;
import org.eclipse.jetty.toolchain.version.issues.IssueSyntax;
import org.kohsuke.github.GHIssue;

@Mojo(name="stage-closed", threadSafe=true)
public class StageClosedMojo
extends AbstractVersionMojo {
    @Parameter(required=true, property="version.stageRepositoryUrl")
    private String stageRepositoryUrl;
    @Parameter(required=true, property="version.jettyVersion", defaultValue="${project.version}")
    private String jettyVersion;
    @Parameter(required=true, property="version.stageClosed.comment", defaultValue="This issue is now available for testing in staged release  ${jettyVersion} available in staging repository ${stageRepositoryUrl}")
    private String comment;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.getLog().debug((CharSequence)("jettyVersion:" + this.jettyVersion));
            VersionPattern verTextPattern = new VersionPattern(this.versionTextKey);
            VersionText versionText = new VersionText(verTextPattern);
            versionText.read(this.versionTextInputFile.toPath());
            this.getLog().debug((CharSequence)("versionList:" + versionText.getVersionList()));
            Optional<Release> releaseOptional = versionText.getReleases().stream().filter(release -> StringUtils.equalsIgnoreCase((CharSequence)release.getVersion(), (CharSequence)this.jettyVersion) || StringUtils.startsWith((CharSequence)release.getVersion(), (CharSequence)("jetty-" + this.jettyVersion))).findFirst();
            if (!releaseOptional.isPresent()) {
                this.getLog().info((CharSequence)("cannot find any release in VERSION.TXT with version " + this.jettyVersion));
                return;
            }
            HashMap<String, String> interpolatedValues = new HashMap<String, String>(2);
            interpolatedValues.put("jettyVersion", this.jettyVersion);
            interpolatedValues.put("stageRepositoryUrl", this.stageRepositoryUrl);
            String resolvedComment = StringSubstitutor.replace((Object)this.comment, interpolatedValues);
            GitHubIssueResolver gitHubIssueResolver = new GitHubIssueResolver(this.repoName).init(this.getLog());
            releaseOptional.get().getIssues().stream().filter(issue -> issue.getSyntax() == IssueSyntax.GITHUB).forEach(issue -> {
                try {
                    GHIssue ghIssue = gitHubIssueResolver.getIssue(issue.getId());
                    ghIssue.comment(resolvedComment);
                }
                catch (IOException e) {
                    this.getLog().warn((CharSequence)("fail to comment issue: " + issue.getId()));
                }
            });
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }
}

