/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.pathmap;

import java.util.List;
import org.eclipse.jetty.http.pathmap.MappedResource;
import org.eclipse.jetty.http.pathmap.PathMappings;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.http.pathmap.UriTemplatePathSpec;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class WebSocketUriMappingTest {
    private PathMappings<String> mapping = new PathMappings();

    private String getBestMatch(String uriPath) {
        List resources = this.mapping.getMatches(uriPath);
        MatcherAssert.assertThat((String)("Matches on " + uriPath), (Object)resources, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        if (resources.isEmpty()) {
            return null;
        }
        return (String)((MappedResource)resources.get(0)).getResource();
    }

    @Test
    public void testJsrExampleI() {
        this.mapping.put("/a/b", (Object)"endpointA");
        MatcherAssert.assertThat((Object)this.getBestMatch("/a/b"), (Matcher)Matchers.is((Object)"endpointA"));
        Assertions.assertNull((Object)this.getBestMatch("/a/c"));
    }

    @Test
    public void testJsrExampleII() {
        this.mapping.put((PathSpec)new UriTemplatePathSpec("/a/{var}"), (Object)"endpointA");
        MatcherAssert.assertThat((Object)this.getBestMatch("/a/b"), (Matcher)Matchers.is((Object)"endpointA"));
        MatcherAssert.assertThat((Object)this.getBestMatch("/a/apple"), (Matcher)Matchers.is((Object)"endpointA"));
        Assertions.assertNull((Object)this.getBestMatch("/a"));
        Assertions.assertNull((Object)this.getBestMatch("/a/b/c"));
    }

    @Test
    public void testJsrExampleIII() {
        this.mapping.put((PathSpec)new UriTemplatePathSpec("/a/{var}/c"), (Object)"endpointA");
        this.mapping.put((PathSpec)new UriTemplatePathSpec("/a/b/c"), (Object)"endpointB");
        this.mapping.put((PathSpec)new UriTemplatePathSpec("/a/{var1}/{var2}"), (Object)"endpointC");
        MatcherAssert.assertThat((Object)this.getBestMatch("/a/b/c"), (Matcher)Matchers.is((Object)"endpointB"));
        MatcherAssert.assertThat((Object)this.getBestMatch("/a/d/c"), (Matcher)Matchers.is((Object)"endpointA"));
        MatcherAssert.assertThat((Object)this.getBestMatch("/a/x/y"), (Matcher)Matchers.is((Object)"endpointC"));
    }

    @Test
    public void testJsrExampleIV() {
        this.mapping.put((PathSpec)new UriTemplatePathSpec("/{var1}/d"), (Object)"endpointA");
        this.mapping.put((PathSpec)new UriTemplatePathSpec("/b/{var2}"), (Object)"endpointB");
        MatcherAssert.assertThat((Object)this.getBestMatch("/b/d"), (Matcher)Matchers.is((Object)"endpointB"));
    }

    @Test
    public void testPrefixVsSuffix() {
        this.mapping.put((PathSpec)new UriTemplatePathSpec("/{a}/b"), (Object)"suffix");
        this.mapping.put((PathSpec)new UriTemplatePathSpec("/{a}/{b}"), (Object)"prefix");
        List matches = this.mapping.getMatches("/a/b");
        MatcherAssert.assertThat((Object)this.getBestMatch("/a/b"), (Matcher)Matchers.is((Object)"suffix"));
    }

    @Test
    public void testMiddleVsSuffix() {
        this.mapping.put((PathSpec)new UriTemplatePathSpec("/a/{b}/c"), (Object)"middle");
        this.mapping.put((PathSpec)new UriTemplatePathSpec("/a/b/{c}"), (Object)"suffix");
        MatcherAssert.assertThat((Object)this.getBestMatch("/a/b/c"), (Matcher)Matchers.is((Object)"suffix"));
    }

    @Test
    public void testMiddleVsSuffix2() {
        this.mapping.put((PathSpec)new UriTemplatePathSpec("/{a}/b/{c}"), (Object)"middle");
        this.mapping.put((PathSpec)new UriTemplatePathSpec("/{a}/b/c"), (Object)"suffix");
        MatcherAssert.assertThat((Object)this.getBestMatch("/a/b/c"), (Matcher)Matchers.is((Object)"suffix"));
    }

    @Test
    public void testMiddleVsPrefix() {
        this.mapping.put((PathSpec)new UriTemplatePathSpec("/a/{b}/{c}/d"), (Object)"middle");
        this.mapping.put((PathSpec)new UriTemplatePathSpec("/a/b/c/{d}"), (Object)"prefix");
        MatcherAssert.assertThat((Object)this.getBestMatch("/a/b/c/d"), (Matcher)Matchers.is((Object)"prefix"));
    }

    @Test
    public void testMiddleVsMiddle() {
        this.mapping.put((PathSpec)new UriTemplatePathSpec("/a/{b}/{c}/d"), (Object)"middle1");
        this.mapping.put((PathSpec)new UriTemplatePathSpec("/a/{b}/c/d"), (Object)"middle2");
        MatcherAssert.assertThat((Object)this.getBestMatch("/a/b/c/d"), (Matcher)Matchers.is((Object)"middle2"));
    }

    @Test
    public void testMiddleVsMiddle2() {
        this.mapping.put((PathSpec)new UriTemplatePathSpec("/{a}/{bz}/c/{d}"), (Object)"middle1");
        this.mapping.put((PathSpec)new UriTemplatePathSpec("/{a}/{ba}/{c}/d"), (Object)"middle2");
        MatcherAssert.assertThat((Object)this.getBestMatch("/a/b/c/d"), (Matcher)Matchers.is((Object)"middle1"));
    }

    @Test
    public void testMiddleVsMiddle3() {
        this.mapping.put((PathSpec)new UriTemplatePathSpec("/{a}/{ba}/c/{d}"), (Object)"middle1");
        this.mapping.put((PathSpec)new UriTemplatePathSpec("/{a}/{bz}/{c}/d"), (Object)"middle2");
        MatcherAssert.assertThat((Object)this.getBestMatch("/a/b/c/d"), (Matcher)Matchers.is((Object)"middle1"));
    }

    @Test
    public void testPrefixVsPrefix() {
        this.mapping.put((PathSpec)new UriTemplatePathSpec("/a/{b}/{c}"), (Object)"prefix1");
        this.mapping.put((PathSpec)new UriTemplatePathSpec("/a/b/{c}"), (Object)"prefix2");
        MatcherAssert.assertThat((Object)this.getBestMatch("/a/b/c"), (Matcher)Matchers.is((Object)"prefix2"));
    }

    @Test
    public void testSuffixVsSuffix() {
        this.mapping.put((PathSpec)new UriTemplatePathSpec("/{a}/{b}/c"), (Object)"suffix1");
        this.mapping.put((PathSpec)new UriTemplatePathSpec("/{a}/b/c"), (Object)"suffix2");
        MatcherAssert.assertThat((Object)this.getBestMatch("/a/b/c"), (Matcher)Matchers.is((Object)"suffix2"));
    }

    @Test
    public void testDifferentLengths() {
        this.mapping.put((PathSpec)new UriTemplatePathSpec("/a/{var}/c"), (Object)"endpointA");
        this.mapping.put((PathSpec)new UriTemplatePathSpec("/a/{var}/c/d"), (Object)"endpointB");
        this.mapping.put((PathSpec)new UriTemplatePathSpec("/a/{var1}/{var2}/d/e"), (Object)"endpointC");
        MatcherAssert.assertThat((Object)this.getBestMatch("/a/b/c"), (Matcher)Matchers.is((Object)"endpointA"));
        MatcherAssert.assertThat((Object)this.getBestMatch("/a/d/c/d"), (Matcher)Matchers.is((Object)"endpointB"));
        MatcherAssert.assertThat((Object)this.getBestMatch("/a/x/y/d/e"), (Matcher)Matchers.is((Object)"endpointC"));
    }
}

