/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.matchers;

import java.util.Objects;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class HttpFieldsHeaderValue
extends TypeSafeMatcher<HttpFields> {
    private final String keyName;
    private final String value;

    public HttpFieldsHeaderValue(String keyName, String value) {
        this.keyName = keyName;
        this.value = value;
    }

    public HttpFieldsHeaderValue(HttpHeader header, String value) {
        this(header.asString(), value);
    }

    public void describeTo(Description description) {
        description.appendText("expecting http header ").appendValue((Object)this.keyName).appendText(" with value ").appendValue((Object)this.value);
    }

    protected boolean matchesSafely(HttpFields fields) {
        HttpField field = fields.getField(this.keyName);
        if (field == null) {
            return false;
        }
        return Objects.equals(this.value, field.getValue());
    }
}

