/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import org.eclipse.jetty.http.Syntax;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SyntaxTest {
    @Test
    public void testRequireValidRFC2616TokenGood() {
        String[] tokens;
        for (String token : tokens = new String[]{"name", "", null, "n.a.m.e", "na-me", "+name", "na*me", "na$me", "#name"}) {
            Syntax.requireValidRFC2616Token((String)token, (String)"Test Based");
        }
    }

    @Test
    public void testRequireValidRFC2616TokenBad() {
        String[] tokens;
        for (String token : tokens = new String[]{"\"name\"", "name\t", "na me", "name\u0082", "na\tme", "na;me", "{name}", "[name]", "\""}) {
            try {
                Syntax.requireValidRFC2616Token((String)token, (String)"Test Based");
                Assertions.fail((String)("RFC2616 Token [" + token + "] Should have thrown " + IllegalArgumentException.class.getName()));
            }
            catch (IllegalArgumentException e) {
                MatcherAssert.assertThat((String)("Testing Bad RFC2616 Token [" + token + "]"), (Object)e.getMessage(), (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"Test Based"), (Matcher)Matchers.containsString((String)"RFC2616")));
            }
        }
    }

    @Test
    public void testRequireValidRFC6265CookieValueGood() {
        String[] values;
        for (String value : values = new String[]{"value", "", null, "val=ue", "val-ue", "\"value\"", "val/ue", "v.a.l.u.e"}) {
            Syntax.requireValidRFC6265CookieValue((String)value);
        }
    }

    @Test
    public void testRequireValidRFC6265CookieValueBad() {
        String[] values;
        for (String value : values = new String[]{"va\tlue", "\t", "value\u0000", "val\u0082ue", "va lue", "va;lue", "\"value", "value\"", "val\\ue", "val\"ue", "\""}) {
            try {
                Syntax.requireValidRFC6265CookieValue((String)value);
                Assertions.fail((String)("RFC6265 Cookie Value [" + value + "] Should have thrown " + IllegalArgumentException.class.getName()));
            }
            catch (IllegalArgumentException e) {
                MatcherAssert.assertThat((String)("Testing Bad RFC6265 Cookie Value [" + value + "]"), (Object)e.getMessage(), (Matcher)Matchers.containsString((String)"RFC6265"));
            }
        }
    }
}

