/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.alpn.client;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLEngine;
import org.eclipse.jetty.alpn.client.ALPNClientConnection;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.NegotiatingClientConnectionFactory;
import org.eclipse.jetty.io.ssl.ALPNProcessor;
import org.eclipse.jetty.io.ssl.SslHandshakeListener;
import org.eclipse.jetty.util.component.ContainerLifeCycle;

public class ALPNClientConnectionFactory
extends NegotiatingClientConnectionFactory
implements SslHandshakeListener {
    private final SslHandshakeListener alpnListener = new ALPNListener();
    private final Executor executor;
    private final List<String> protocols;
    private final ALPNProcessor.Client alpnProcessor;

    public ALPNClientConnectionFactory(Executor executor, ClientConnectionFactory connectionFactory, List<String> protocols) {
        super(connectionFactory);
        if (protocols.isEmpty()) {
            throw new IllegalArgumentException("ALPN protocol list cannot be empty");
        }
        this.executor = executor;
        this.protocols = protocols;
        Iterator<ALPNProcessor.Client> processors = ServiceLoader.load(ALPNProcessor.Client.class).iterator();
        this.alpnProcessor = processors.hasNext() ? processors.next() : ALPNProcessor.Client.NOOP;
    }

    public ALPNProcessor.Client getALPNProcessor() {
        return this.alpnProcessor;
    }

    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
        SSLEngine sslEngine = (SSLEngine)context.get("ssl.engine");
        this.getALPNProcessor().configure(sslEngine, this.protocols);
        ContainerLifeCycle connector = (ContainerLifeCycle)context.get("client.connector");
        connector.addBean((Object)this.alpnListener);
        ALPNClientConnection connection = new ALPNClientConnection(endPoint, this.executor, this.getClientConnectionFactory(), sslEngine, context, this.protocols);
        return this.customize((Connection)connection, context);
    }

    private class ALPNListener
    implements SslHandshakeListener {
        private ALPNListener() {
        }

        public void handshakeSucceeded(SslHandshakeListener.Event event) {
            ALPNClientConnectionFactory.this.getALPNProcessor().process(event.getSSLEngine());
        }

        public void handshakeFailed(SslHandshakeListener.Event event, Throwable failure) {
        }
    }
}

