/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.graph;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum GSeverity implements Enumerator
{
    ERROR(0, "error", "error"),
    WARNING(1, "warning", "warning"),
    INFO(2, "info", "info");

    public static final int ERROR_VALUE = 0;
    public static final int WARNING_VALUE = 1;
    public static final int INFO_VALUE = 2;
    private static final GSeverity[] VALUES_ARRAY;
    public static final List<GSeverity> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static GSeverity get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            GSeverity result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static GSeverity getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            GSeverity result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static GSeverity get(int value) {
        switch (value) {
            case 0: {
                return ERROR;
            }
            case 1: {
                return WARNING;
            }
            case 2: {
                return INFO;
            }
        }
        return null;
    }

    private GSeverity(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new GSeverity[]{ERROR, WARNING, INFO};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

