/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.Inet6Address;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.MessageDigest;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import javax.security.auth.x500.X500Principal;
import org.eclipse.californium.elements.RawData;
import org.eclipse.californium.elements.auth.AdditionalInfo;
import org.eclipse.californium.elements.auth.ExtensiblePrincipal;
import org.eclipse.californium.elements.auth.PreSharedKeyIdentity;
import org.eclipse.californium.elements.auth.RawPublicKeyIdentity;
import org.eclipse.californium.elements.auth.X509CertPath;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.ClockUtil;
import org.eclipse.californium.elements.util.NoPublicAPI;
import org.eclipse.californium.elements.util.SerialExecutor;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.auth.ApplicationLevelInfoSupplier;
import org.eclipse.californium.scandium.config.DtlsConfig;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.CertificateIdentityResult;
import org.eclipse.californium.scandium.dtls.CertificateMessage;
import org.eclipse.californium.scandium.dtls.CertificateVerificationResult;
import org.eclipse.californium.scandium.dtls.ChangeCipherSpecMessage;
import org.eclipse.californium.scandium.dtls.Connection;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.ConnectionIdGenerator;
import org.eclipse.californium.scandium.dtls.ContentType;
import org.eclipse.californium.scandium.dtls.DTLSContext;
import org.eclipse.californium.scandium.dtls.DTLSFlight;
import org.eclipse.californium.scandium.dtls.DTLSMessage;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.DtlsException;
import org.eclipse.californium.scandium.dtls.DtlsHandshakeTimeoutException;
import org.eclipse.californium.scandium.dtls.ExtendedMasterSecretMode;
import org.eclipse.californium.scandium.dtls.Finished;
import org.eclipse.californium.scandium.dtls.FragmentedHandshakeMessage;
import org.eclipse.californium.scandium.dtls.GenericHandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeParameter;
import org.eclipse.californium.scandium.dtls.HandshakeResult;
import org.eclipse.californium.scandium.dtls.HandshakeState;
import org.eclipse.californium.scandium.dtls.HandshakeType;
import org.eclipse.californium.scandium.dtls.PskPublicInformation;
import org.eclipse.californium.scandium.dtls.PskSecretResult;
import org.eclipse.californium.scandium.dtls.Random;
import org.eclipse.californium.scandium.dtls.ReassemblingHandshakeMessage;
import org.eclipse.californium.scandium.dtls.Record;
import org.eclipse.californium.scandium.dtls.RecordLayer;
import org.eclipse.californium.scandium.dtls.SessionListener;
import org.eclipse.californium.scandium.dtls.SignatureAndHashAlgorithm;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.cipher.PseudoRandomFunction;
import org.eclipse.californium.scandium.dtls.cipher.RandomManager;
import org.eclipse.californium.scandium.dtls.cipher.XECDHECryptography;
import org.eclipse.californium.scandium.dtls.pskstore.AdvancedPskStore;
import org.eclipse.californium.scandium.dtls.x509.CertificateProvider;
import org.eclipse.californium.scandium.dtls.x509.NewAdvancedCertificateVerifier;
import org.eclipse.californium.scandium.util.SecretIvParameterSpec;
import org.eclipse.californium.scandium.util.SecretUtil;
import org.eclipse.californium.scandium.util.ServerNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Handshaker
implements Destroyable {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected Random clientRandom;
    protected Random serverRandom;
    private byte[] masterSecretSeed;
    private SecretKey masterSecret;
    private SecretKey clientWriteMACKey;
    private SecretKey serverWriteMACKey;
    private SecretKey clientWriteKey;
    private SecretKey serverWriteKey;
    private SecretIvParameterSpec clientWriteIV;
    private SecretIvParameterSpec serverWriteIV;
    private volatile boolean generateClusterMacKeys;
    private boolean destroyed;
    private final ReentrantLock recursionProtection = new ReentrantLock();
    private final boolean ipv6;
    private final DTLSContext context;
    protected final NewAdvancedCertificateVerifier certificateVerifier;
    protected final AdvancedPskStore advancedPskStore;
    protected final ConnectionIdGenerator connectionIdGenerator;
    private int sendMessageSequence = 0;
    private int nextReceiveMessageSequence = 0;
    private long flightSendNanos;
    private long nanosExpireTime;
    private final long nanosExpireTimeout;
    protected int flightNumber = 0;
    protected Integer recordSizeLimit;
    private int deferredIncomingRecordsSize;
    private final int maxFragmentedHandshakeMessageLength;
    private final int maxDeferredProcessedOutgoingApplicationDataMessages;
    private final int maxDeferredProcessedIncomingRecordsSize;
    private final List<RawData> deferredApplicationData = new ArrayList<RawData>();
    private final List<Record> nextEpochDeferredRecords = new ArrayList<Record>();
    private final AtomicReference<DTLSFlight> pendingFlight = new AtomicReference();
    private Runnable retransmitFlight;
    private ScheduledFuture<?> timeoutLastFlight;
    private final ScheduledExecutorService timer;
    private final RecordLayer recordLayer;
    private final Connection connection;
    private final InetSocketAddress peer;
    protected final Object peerToLog;
    private InboundMessageBuffer inboundMessageBuffer;
    protected final List<HandshakeMessage> handshakeMessages = new ArrayList<HandshakeMessage>();
    private ReassemblingHandshakeMessage reassembledMessage;
    protected final CertificateProvider certificateIdentityProvider;
    protected PrivateKey privateKey;
    protected PublicKey publicKey;
    protected List<X509Certificate> certificateChain;
    private CertPath otherPeersCertPath;
    protected PublicKey otherPeersPublicKey;
    protected boolean otherPeersCertificateVerified;
    private boolean otherPeersSignatureVerified;
    protected final boolean sniEnabled;
    protected final ExtendedMasterSecretMode extendedMasterSecretMode;
    protected final boolean useTruncatedCertificatePathForVerification;
    private final boolean useEarlyStopRetransmission;
    private Boolean useMultiRecordMessages;
    private Boolean useMultiHandshakeMessagesRecord;
    private final int backOffRetransmission;
    private final int maxRetransmissions;
    private final int retransmissionTimeout;
    private final int maxRetransmissionTimeout;
    private final float retransmissionRandomFactor;
    private final float retransmissionTimeoutScale;
    private final int additionalTimeoutForEcc;
    private final Set<SessionListener> sessionListeners = new LinkedHashSet<SessionListener>();
    private boolean statesChanged;
    private int statesIndex;
    private HandshakeState[] expectedStates;
    private boolean eccExpected;
    private boolean changeCipherSuiteMessageExpected;
    private boolean contextEstablished;
    private boolean handshakeCompleted;
    private boolean handshakeAborted;
    private boolean handshakeFailed;
    private boolean pskRequestPending;
    private boolean certificateVerificationPending;
    private boolean certificateIdentityPending;
    protected boolean certificateIdentityAvailable;
    private SecretKey otherSecret;
    private Throwable cause;
    private Object customArgument;
    private ApplicationLevelInfoSupplier applicationLevelInfoSupplier;

    @NoPublicAPI
    protected Handshaker(long initialRecordSequenceNo, int initialMessageSeq, RecordLayer recordLayer, ScheduledExecutorService timer, Connection connection, DtlsConnectorConfig config) {
        if (recordLayer == null) {
            throw new NullPointerException("Record layer must not be null");
        }
        if (timer == null) {
            throw new NullPointerException("Timer must not be null");
        }
        if (connection == null) {
            throw new NullPointerException("Connection must not be null");
        }
        if (config == null) {
            throw new NullPointerException("Dtls Connector Config must not be null");
        }
        if (initialMessageSeq < 0) {
            throw new IllegalArgumentException("Initial message sequence number must not be negative");
        }
        if (initialRecordSequenceNo < 0L) {
            throw new IllegalArgumentException("Initial record sequence number must not be negative");
        }
        this.sendMessageSequence = initialMessageSeq;
        this.nextReceiveMessageSequence = initialMessageSeq;
        this.context = new DTLSContext(initialRecordSequenceNo);
        this.recordLayer = recordLayer;
        this.timer = timer;
        this.connection = connection;
        this.peer = connection.getPeerAddress();
        this.peerToLog = StringUtil.toLog((SocketAddress)this.peer);
        this.connectionIdGenerator = config.getConnectionIdGenerator();
        this.retransmissionTimeout = config.getTimeAsInt(DtlsConfig.DTLS_RETRANSMISSION_TIMEOUT, TimeUnit.MILLISECONDS);
        this.maxRetransmissionTimeout = config.getTimeAsInt(DtlsConfig.DTLS_MAX_RETRANSMISSION_TIMEOUT, TimeUnit.MILLISECONDS);
        this.additionalTimeoutForEcc = config.getTimeAsInt(DtlsConfig.DTLS_ADDITIONAL_ECC_TIMEOUT, TimeUnit.MILLISECONDS);
        this.retransmissionRandomFactor = ((Float)config.get(DtlsConfig.DTLS_RETRANSMISSION_INIT_RANDOM)).floatValue();
        this.retransmissionTimeoutScale = ((Float)config.get(DtlsConfig.DTLS_RETRANSMISSION_TIMEOUT_SCALE)).floatValue();
        this.backOffRetransmission = config.getBackOffRetransmission();
        this.maxRetransmissions = (Integer)config.get(DtlsConfig.DTLS_MAX_RETRANSMISSIONS);
        this.recordSizeLimit = (Integer)config.get(DtlsConfig.DTLS_RECORD_SIZE_LIMIT);
        this.maxFragmentedHandshakeMessageLength = (Integer)config.get(DtlsConfig.DTLS_MAX_FRAGMENTED_HANDSHAKE_MESSAGE_LENGTH);
        this.useMultiRecordMessages = (Boolean)config.get(DtlsConfig.DTLS_USE_MULTI_RECORD_MESSAGES);
        this.useMultiHandshakeMessagesRecord = (Boolean)config.get(DtlsConfig.DTLS_USE_MULTI_HANDSHAKE_MESSAGE_RECORDS);
        this.maxDeferredProcessedOutgoingApplicationDataMessages = (Integer)config.get(DtlsConfig.DTLS_MAX_DEFERRED_OUTBOUND_APPLICATION_MESSAGES);
        this.maxDeferredProcessedIncomingRecordsSize = (Integer)config.get(DtlsConfig.DTLS_MAX_DEFERRED_INBOUND_RECORDS_SIZE);
        this.sniEnabled = (Boolean)config.get(DtlsConfig.DTLS_USE_SERVER_NAME_INDICATION);
        this.extendedMasterSecretMode = config.get(DtlsConfig.DTLS_EXTENDED_MASTER_SECRET_MODE);
        this.useTruncatedCertificatePathForVerification = (Boolean)config.get(DtlsConfig.DTLS_TRUNCATE_CERTIFICATE_PATH_FOR_VALIDATION);
        this.useEarlyStopRetransmission = (Boolean)config.get(DtlsConfig.DTLS_USE_EARLY_STOP_RETRANSMISSION);
        this.certificateIdentityProvider = config.getCertificateIdentityProvider();
        this.certificateVerifier = config.getAdvancedCertificateVerifier();
        this.advancedPskStore = config.getAdvancedPskStore();
        this.applicationLevelInfoSupplier = config.getApplicationLevelInfoSupplier();
        this.inboundMessageBuffer = new InboundMessageBuffer();
        this.ipv6 = connection.getPeerAddress().getAddress() instanceof Inet6Address;
        int timeoutMillis = Math.round((float)this.retransmissionTimeout * this.retransmissionRandomFactor);
        if (CipherSuite.containsEccBasedCipherSuite(config.getSupportedCipherSuites())) {
            timeoutMillis += this.additionalTimeoutForEcc;
        }
        timeoutMillis = Math.min(timeoutMillis, this.maxRetransmissionTimeout);
        int expireTimeoutMillis = Math.min(Math.round((float)timeoutMillis * this.retransmissionTimeoutScale), this.maxRetransmissionTimeout);
        for (int retry = 0; retry < this.maxRetransmissions; ++retry) {
            timeoutMillis = DTLSFlight.incrementTimeout(timeoutMillis, this.retransmissionTimeoutScale, this.maxRetransmissionTimeout);
            expireTimeoutMillis += timeoutMillis;
        }
        this.nanosExpireTimeout = TimeUnit.MILLISECONDS.toNanos(expireTimeoutMillis);
        this.addSessionListener(connection.getSessionListener());
    }

    private static int compareRecords(Record r1, Record r2) {
        if (r1.getEpoch() != r2.getEpoch()) {
            throw new IllegalArgumentException("records with different epoch! " + r1.getEpoch() + " != " + r2.getEpoch());
        }
        HandshakeMessage h1 = (HandshakeMessage)r1.getFragment();
        HandshakeMessage h2 = (HandshakeMessage)r2.getFragment();
        if (h1.getMessageSeq() < h2.getMessageSeq()) {
            return -1;
        }
        if (h1.getMessageSeq() > h2.getMessageSeq()) {
            return 1;
        }
        if (r1.getSequenceNumber() < r2.getSequenceNumber()) {
            return -1;
        }
        if (r1.getSequenceNumber() > r2.getSequenceNumber()) {
            return 1;
        }
        return 0;
    }

    public boolean isInboundMessageProcessed() {
        return this.inboundMessageBuffer.isEmpty();
    }

    public final void processMessage(Record record) throws HandshakeException {
        int epoch = this.context.getReadEpoch();
        if (epoch != record.getEpoch()) {
            this.LOGGER.debug("Discarding {} message with wrong epoch received from peer [{}]:{}{}", new Object[]{record.getType(), record.getPeerAddress(), StringUtil.lineSeparator(), record});
            throw new IllegalArgumentException("processing record with wrong epoch! " + record.getEpoch() + " expected " + epoch);
        }
        if (this.pendingFlight.get() != null && this.flightSendNanos - record.getReceiveNanos() > 0L) {
            this.LOGGER.debug("Discarding {} message received from peer [{}] before last flight was sent:{}{}", new Object[]{record.getType(), record.getPeerAddress(), StringUtil.lineSeparator(), record});
            return;
        }
        Record recordToProcess = this.inboundMessageBuffer.getNextRecord(record);
        if (recordToProcess != null) {
            this.processNextMessages(recordToProcess);
        }
    }

    private void processNextMessages(Record record) throws HandshakeException {
        if (this.recursionProtection.isHeldByCurrentThread()) {
            this.LOGGER.warn("Called from doProcessMessage, return immediately to process next message!", new Throwable("recursion-protection"));
            return;
        }
        try {
            Record recordToProcess;
            int epoch = this.context.getReadEpoch();
            int bufferIndex = 0;
            Record record2 = recordToProcess = record != null ? record : this.inboundMessageBuffer.getNextRecord();
            while (recordToProcess != null) {
                DTLSMessage messageToProcess;
                if (this.useMultiRecordMessages == null && recordToProcess.isFollowUpRecord()) {
                    this.useMultiRecordMessages = true;
                }
                if ((messageToProcess = recordToProcess.getFragment()).getContentType() == ContentType.CHANGE_CIPHER_SPEC) {
                    this.expectMessage(messageToProcess);
                    this.LOGGER.debug("Processing {} message from peer [{}]", (Object)messageToProcess.getContentType(), this.peerToLog);
                    this.setCurrentReadState();
                    ++this.statesIndex;
                    this.LOGGER.debug("Processed {} message from peer [{}]", (Object)messageToProcess.getContentType(), this.peerToLog);
                } else if (messageToProcess.getContentType() == ContentType.HANDSHAKE) {
                    boolean more = this.processNextHandshakeMessages(recordToProcess.getEpoch(), bufferIndex, (HandshakeMessage)messageToProcess);
                    this.context.markRecordAsRead(recordToProcess.getEpoch(), recordToProcess.getSequenceNumber());
                    if (!more) {
                        break;
                    }
                } else {
                    throw new HandshakeException(String.format("Received unexpected message type [%s] from peer %s", new Object[]{messageToProcess.getContentType(), this.peerToLog}), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE));
                }
                recordToProcess = this.inboundMessageBuffer.getNextRecord();
                if (!(epoch >= this.context.getReadEpoch() || recordToProcess == null && this.inboundMessageBuffer.isEmpty())) {
                    throw new HandshakeException(String.format("Unexpected handshake message left from peer %s", this.peerToLog), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE));
                }
                ++bufferIndex;
            }
            if (epoch < this.context.getReadEpoch()) {
                SerialExecutor serialExecutor = this.connection.getExecutor();
                List<Record> records = this.takeDeferredRecordsOfNextEpoch();
                if (this.deferredIncomingRecordsSize > 0) {
                    throw new HandshakeException(String.format("Received message of next epoch left from peer %s", this.peerToLog), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR));
                }
                for (Record deferredRecord : records) {
                    if (serialExecutor != null && !serialExecutor.isShutdown()) {
                        try {
                            final Record dRecord = deferredRecord;
                            serialExecutor.execute(new Runnable(){

                                @Override
                                public void run() {
                                    Handshaker.this.recordLayer.processRecord(dRecord, Handshaker.this.connection);
                                }
                            });
                            continue;
                        }
                        catch (RejectedExecutionException ex) {
                            this.LOGGER.debug("Execution rejected while processing record [type: {}, peer: {}]", new Object[]{deferredRecord.getType(), deferredRecord.getPeerAddress(), ex});
                        }
                    }
                    this.recordLayer.processRecord(deferredRecord, this.connection);
                }
            }
        }
        catch (RuntimeException e) {
            this.LOGGER.warn("Cannot process handshake message from peer [{}] due to [{}]", new Object[]{this.peerToLog, e.getMessage(), e});
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR);
            throw new HandshakeException("Cannot process handshake message, caused by " + e.getMessage(), alert, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processNextHandshakeMessages(int epoch, int bufferIndex, HandshakeMessage handshakeMessage) throws HandshakeException {
        if (this.recursionProtection.isHeldByCurrentThread()) {
            this.LOGGER.warn("Called from doProcessMessage, return immediately to process next message!", new Throwable("recursion-protection"));
            return false;
        }
        DTLSFlight flight = this.pendingFlight.get();
        if (flight != null) {
            this.LOGGER.debug("response for flight {} started", (Object)flight.getFlightNumber());
            flight.setResponseStarted();
        }
        while (handshakeMessage != null) {
            this.expectMessage(handshakeMessage);
            if (handshakeMessage.getMessageType() == HandshakeType.FINISHED && epoch == 0) {
                this.LOGGER.debug("FINISH with epoch 0 from peer [{}]!", this.peerToLog);
                AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNEXPECTED_MESSAGE);
                throw new HandshakeException("FINISH with epoch 0!", alert);
            }
            if (handshakeMessage instanceof FragmentedHandshakeMessage && (handshakeMessage = this.reassembleFragment((FragmentedHandshakeMessage)handshakeMessage)) == null) break;
            if (handshakeMessage instanceof GenericHandshakeMessage) {
                GenericHandshakeMessage genericMessage = (GenericHandshakeMessage)handshakeMessage;
                handshakeMessage = HandshakeMessage.fromGenericHandshakeMessage(genericMessage, this.getParameter());
            }
            if (this.timeoutLastFlight != null) {
                if (flight == null) {
                    if (this.cause != null) {
                        this.LOGGER.error("last flight missing, handshake already failed! {}", (Object)handshakeMessage, (Object)this.cause);
                    } else if (bufferIndex == 0) {
                        this.LOGGER.error("last flight missing, resend failed! {}", (Object)handshakeMessage);
                    } else {
                        this.LOGGER.error("last flight missing, resend for buffered message {} failed! {}", (Object)bufferIndex, (Object)handshakeMessage);
                    }
                    return false;
                }
                this.LOGGER.debug("Received ({}) FINISHED message again, retransmitting last flight...", this.peerToLog);
                flight.incrementTries();
                this.sendFlight(flight);
                return false;
            }
            if (this.LOGGER.isDebugEnabled()) {
                StringBuilder msg = new StringBuilder();
                msg.append(String.format("Processing %s message from peer [%s], seqn: [%d]", new Object[]{handshakeMessage.getMessageType(), this.peerToLog, handshakeMessage.getMessageSeq()}));
                if (this.LOGGER.isTraceEnabled()) {
                    msg.append(":").append(StringUtil.lineSeparator()).append(handshakeMessage);
                }
                this.LOGGER.debug(msg.toString());
            }
            if (epoch == 0) {
                this.handshakeMessages.add(handshakeMessage);
            }
            this.statesChanged = false;
            this.recursionProtection.lock();
            try {
                this.doProcessMessage(handshakeMessage);
            }
            finally {
                this.recursionProtection.unlock();
            }
            this.LOGGER.debug("Processed {} message from peer [{}]", (Object)handshakeMessage.getMessageType(), this.peerToLog);
            if (this.timeoutLastFlight == null) {
                ++this.nextReceiveMessageSequence;
                if (!this.statesChanged) {
                    ++this.statesIndex;
                }
            }
            handshakeMessage = handshakeMessage.getNextHandshakeMessage();
            if (this.useMultiHandshakeMessagesRecord != null || handshakeMessage == null) continue;
            this.useMultiHandshakeMessagesRecord = true;
        }
        return true;
    }

    protected boolean isExpectedStates(HandshakeState[] states) {
        return this.expectedStates == states;
    }

    protected void setExpectedStates(HandshakeState[] states) {
        this.expectedStates = states;
        this.statesIndex = 0;
        this.statesChanged = true;
    }

    protected void expectMessage(DTLSMessage message) throws HandshakeException {
        HandshakeState nextExpectedState;
        if (this.expectedStates == null) {
            this.LOGGER.warn("Cannot process {} message from peer [{}], not expected!", (Object)HandshakeState.toString(message), this.peerToLog);
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR);
            throw new HandshakeException("Cannot process " + HandshakeState.toString(message) + " handshake message, not expected!", alert);
        }
        if (this.expectedStates.length == 0) {
            return;
        }
        if (this.statesIndex >= this.expectedStates.length) {
            this.LOGGER.warn("Cannot process {} message from peer [{}], no more expected!", (Object)HandshakeState.toString(message), this.peerToLog);
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR);
            throw new HandshakeException("Cannot process " + HandshakeState.toString(message) + " handshake message, no more expected!", alert);
        }
        HandshakeState expectedState = this.expectedStates[this.statesIndex];
        boolean expected = expectedState.expect(message);
        if (!expected && expectedState.isOptional() && this.statesIndex + 1 < this.expectedStates.length && (nextExpectedState = this.expectedStates[this.statesIndex + 1]).expect(message)) {
            ++this.statesIndex;
            expected = true;
        }
        if (!expected) {
            DTLSFlight flight = this.pendingFlight.get();
            if (flight != null && flight.contains(message)) {
                this.LOGGER.debug("Cannot process {} message from itself [{}]!", (Object)HandshakeState.toString(message), this.peerToLog);
            } else {
                this.LOGGER.debug("Cannot process {} message from peer [{}], {} expected!", new Object[]{HandshakeState.toString(message), this.peerToLog, expectedState});
            }
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNEXPECTED_MESSAGE);
            throw new HandshakeException("Cannot process " + HandshakeState.toString(message) + " handshake message, " + expectedState + " expected!", alert);
        }
    }

    protected abstract void doProcessMessage(HandshakeMessage var1) throws HandshakeException;

    public void processAsyncHandshakeResult(HandshakeResult handshakeResult) throws HandshakeException {
        if (handshakeResult instanceof PskSecretResult) {
            this.processPskSecretResult((PskSecretResult)handshakeResult);
        } else if (handshakeResult instanceof CertificateVerificationResult) {
            this.processCertificateVerificationResult((CertificateVerificationResult)handshakeResult);
        } else if (handshakeResult instanceof CertificateIdentityResult) {
            this.processCertificateIdentityResult((CertificateIdentityResult)handshakeResult);
        }
        if (this.changeCipherSuiteMessageExpected) {
            this.processNextMessages(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processPskSecretResult(PskSecretResult pskSecretResult) throws HandshakeException {
        block9: {
            if (!this.pskRequestPending) {
                throw new IllegalStateException("psk secret not pending!");
            }
            this.pskRequestPending = false;
            try {
                this.ensureUndestroyed();
                DTLSSession session = this.getSession();
                String hostName = this.sniEnabled ? session.getHostName() : null;
                PskPublicInformation pskIdentity = pskSecretResult.getPskPublicInformation();
                SecretKey newPskSecret = pskSecretResult.getSecret();
                if (newPskSecret != null) {
                    if (hostName != null) {
                        this.LOGGER.trace("client [{}] uses PSK identity [{}] for server [{}]", new Object[]{this.peerToLog, pskIdentity, hostName});
                    } else {
                        this.LOGGER.trace("client [{}] uses PSK identity [{}]", this.peerToLog, (Object)pskIdentity);
                    }
                    PreSharedKeyIdentity pskPrincipal = this.sniEnabled ? new PreSharedKeyIdentity(hostName, pskIdentity.getPublicInfoAsString()) : new PreSharedKeyIdentity(pskIdentity.getPublicInfoAsString());
                    session.setPeerIdentity((Principal)pskPrincipal);
                    if ("PSK".equals(newPskSecret.getAlgorithm())) {
                        Mac hmac = session.getCipherSuite().getThreadLocalPseudoRandomFunctionMac();
                        SecretKey premasterSecret = PseudoRandomFunction.generatePremasterSecretFromPSK(this.otherSecret, newPskSecret);
                        SecretKey masterSecret = PseudoRandomFunction.generateMasterSecret(hmac, premasterSecret, this.masterSecretSeed, session.useExtendedMasterSecret());
                        SecretUtil.destroy(premasterSecret);
                        SecretUtil.destroy(newPskSecret);
                        newPskSecret = masterSecret;
                    }
                    this.setCustomArgument(pskSecretResult);
                    this.applyMasterSecret(newPskSecret);
                    SecretUtil.destroy(newPskSecret);
                    this.processMasterSecret();
                    break block9;
                }
                AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNKNOWN_PSK_IDENTITY);
                if (hostName != null) {
                    throw new HandshakeException(String.format("No pre-shared key found for [virtual host: %s, identity: %s]", new Object[]{hostName, pskIdentity}), alert);
                }
                throw new HandshakeException(String.format("No pre-shared key found for [identity: %s]", new Object[]{pskIdentity}), alert);
            }
            finally {
                SecretUtil.destroy(this.otherSecret);
                this.otherSecret = null;
            }
        }
    }

    protected abstract void processMasterSecret() throws HandshakeException;

    protected void processCertificateVerificationResult(CertificateVerificationResult certificateVerificationResult) throws HandshakeException {
        if (!this.certificateVerificationPending) {
            throw new IllegalStateException("certificate verification not pending!");
        }
        this.ensureUndestroyed();
        this.certificateVerificationPending = false;
        this.LOGGER.debug("Process result of certificate verification.");
        if (certificateVerificationResult.getCertificatePath() != null) {
            this.otherPeersCertificateVerified = true;
            this.otherPeersCertPath = certificateVerificationResult.getCertificatePath();
            if (this.otherPeersSignatureVerified) {
                this.getSession().setPeerIdentity((Principal)new X509CertPath(this.otherPeersCertPath));
            }
            this.setCustomArgument(certificateVerificationResult);
            this.processCertificateVerified();
        } else if (certificateVerificationResult.getPublicKey() != null) {
            this.otherPeersCertificateVerified = true;
            if (this.otherPeersSignatureVerified) {
                this.getSession().setPeerIdentity((Principal)new RawPublicKeyIdentity(this.otherPeersPublicKey));
            }
            this.setCustomArgument(certificateVerificationResult);
            this.processCertificateVerified();
        } else {
            if (certificateVerificationResult.getException() != null) {
                throw certificateVerificationResult.getException();
            }
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.BAD_CERTIFICATE);
            throw new HandshakeException("Bad Certificate", alert);
        }
    }

    protected abstract void processCertificateVerified() throws HandshakeException;

    protected void processCertificateIdentityResult(CertificateIdentityResult result) throws HandshakeException {
        if (!this.certificateIdentityPending) {
            throw new IllegalStateException("certificate identity not pending!");
        }
        this.ensureUndestroyed();
        this.certificateIdentityPending = false;
        this.LOGGER.debug("Process result of certificate identity.");
        this.privateKey = result.getPrivateKey();
        this.publicKey = result.getPublicKey();
        this.certificateChain = result.getCertificateChain();
        this.certificateIdentityAvailable = true;
        this.processCertificateIdentityAvailable();
    }

    protected abstract void processCertificateIdentityAvailable() throws HandshakeException;

    protected void setCustomArgument(HandshakeResult result) {
        Object customArgument = result.getCustomArgument();
        if (customArgument != null) {
            this.customArgument = customArgument;
        }
    }

    protected boolean hasPendingApiCall() {
        return this.certificateIdentityPending || this.certificateVerificationPending || this.pskRequestPending;
    }

    protected boolean setOtherPeersSignatureVerified() {
        this.otherPeersSignatureVerified = true;
        if (this.otherPeersCertificateVerified) {
            if (this.otherPeersCertPath != null) {
                this.getSession().setPeerIdentity((Principal)new X509CertPath(this.otherPeersCertPath));
            } else if (this.otherPeersPublicKey != null) {
                this.getSession().setPeerIdentity((Principal)new RawPublicKeyIdentity(this.otherPeersPublicKey));
            }
        }
        return this.otherPeersCertificateVerified;
    }

    protected final MessageDigest getHandshakeMessageDigest() {
        MessageDigest md = this.getSession().getCipherSuite().getThreadLocalPseudoRandomFunctionMessageDigest();
        int index = 0;
        for (HandshakeMessage handshakeMessage : this.handshakeMessages) {
            md.update(handshakeMessage.toByteArray());
            this.LOGGER.trace("  [{}] - {}", (Object)index, (Object)handshakeMessage.getMessageType());
            ++index;
        }
        return md;
    }

    protected final MessageDigest cloneMessageDigest(MessageDigest md) throws HandshakeException {
        try {
            return (MessageDigest)md.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new HandshakeException("Cannot create hash for second FINISHED message", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR));
        }
    }

    protected void applyMasterSecret(SecretKey masterSecret) {
        this.ensureUndestroyed();
        this.masterSecret = SecretUtil.create(masterSecret);
        this.calculateKeys(masterSecret);
        this.getSession().setMasterSecret(masterSecret);
    }

    protected void resumeMasterSecret() {
        this.ensureUndestroyed();
        this.masterSecret = this.getSession().getMasterSecret();
        this.calculateKeys(this.masterSecret);
    }

    protected void calculateKeys(SecretKey masterSecret) {
        this.ensureUndestroyed();
        CipherSuite cipherSuite = this.context.getSession().getCipherSuite();
        int macKeyLength = cipherSuite.getMacKeyLength();
        int encKeyLength = cipherSuite.getEncKeyLength();
        int fixedIvLength = cipherSuite.getFixedIvLength();
        int clusterMacKeyLength = this.generateClusterMacKeys ? encKeyLength : 0;
        int totalLength = (macKeyLength + encKeyLength + fixedIvLength + clusterMacKeyLength) * 2;
        byte[] seed = Bytes.concatenate((Bytes)this.serverRandom, (Bytes)this.clientRandom);
        byte[] data = PseudoRandomFunction.doPRF(cipherSuite.getThreadLocalPseudoRandomFunctionMac(), masterSecret, PseudoRandomFunction.Label.KEY_EXPANSION_LABEL, seed, totalLength);
        int index = 0;
        int length = macKeyLength;
        this.clientWriteMACKey = SecretUtil.create(data, index, length, "Mac");
        this.serverWriteMACKey = SecretUtil.create(data, index += length, length, "Mac");
        index += length;
        length = encKeyLength;
        this.clientWriteKey = SecretUtil.create(data, index, length, "AES");
        this.serverWriteKey = SecretUtil.create(data, index += length, length, "AES");
        index += length;
        length = fixedIvLength;
        this.clientWriteIV = SecretUtil.createIv(data, index, length);
        this.serverWriteIV = SecretUtil.createIv(data, index += length, length);
        if (this.generateClusterMacKeys) {
            length = clusterMacKeyLength;
            SecretKey clusterClientMacKey = SecretUtil.create(data, index, length, "Mac");
            SecretKey clusterServerMacKey = SecretUtil.create(data, index += length, length, "Mac");
            index += length;
            if (this.isClient()) {
                this.context.setClusterMacKeys(clusterClientMacKey, clusterServerMacKey);
            } else {
                this.context.setClusterMacKeys(clusterServerMacKey, clusterClientMacKey);
            }
            SecretUtil.destroy(clusterClientMacKey);
            SecretUtil.destroy(clusterServerMacKey);
        }
        Bytes.clear((byte[])data);
    }

    protected byte[] generateMasterSecretSeed() {
        if (this.getSession().useExtendedMasterSecret()) {
            MessageDigest md = this.getSession().getCipherSuite().getThreadLocalPseudoRandomFunctionMessageDigest();
            int index = 0;
            for (HandshakeMessage handshakeMessage : this.handshakeMessages) {
                md.update(handshakeMessage.toByteArray());
                this.LOGGER.trace("  [{}] - {}", (Object)index++, (Object)handshakeMessage.getMessageType());
                if (handshakeMessage.getMessageType() != HandshakeType.CLIENT_KEY_EXCHANGE) continue;
                return md.digest();
            }
            throw new IllegalArgumentException("client key exchange missing!");
        }
        return Bytes.concatenate((Bytes)this.clientRandom, (Bytes)this.serverRandom);
    }

    protected void requestPskSecretResult(PskPublicInformation pskIdentity, SecretKey otherSecret, byte[] seed) throws HandshakeException {
        if (seed == null) {
            throw new NullPointerException("seed must not be null!");
        }
        DTLSSession session = this.getSession();
        ServerNames serverNames = this.getServerNames();
        String hmacAlgorithm = session.getCipherSuite().getPseudoRandomFunctionMacName();
        this.pskRequestPending = true;
        this.masterSecretSeed = seed;
        this.otherSecret = SecretUtil.create(otherSecret);
        PskSecretResult result = this.advancedPskStore.requestPskSecretResult(this.connection.getConnectionId(), serverNames, pskIdentity, hmacAlgorithm, otherSecret, this.masterSecretSeed, session.useExtendedMasterSecret());
        if (result != null) {
            this.processPskSecretResult(result);
        }
    }

    protected final void setCurrentReadState() {
        if (this.isClient()) {
            this.context.createReadState(this.serverWriteKey, this.serverWriteIV, this.serverWriteMACKey);
        } else {
            this.context.createReadState(this.clientWriteKey, this.clientWriteIV, this.clientWriteMACKey);
        }
    }

    protected final void setCurrentWriteState() {
        if (this.isClient()) {
            this.context.createWriteState(this.clientWriteKey, this.clientWriteIV, this.clientWriteMACKey);
        } else {
            this.context.createWriteState(this.serverWriteKey, this.serverWriteIV, this.serverWriteMACKey);
        }
    }

    protected final Finished createFinishedMessage(byte[] handshakeHash) {
        if (this.masterSecret == null) {
            throw new IllegalStateException("master secret not available!");
        }
        return new Finished(this.getSession().getCipherSuite().getThreadLocalPseudoRandomFunctionMac(), this.masterSecret, this.isClient(), handshakeHash);
    }

    protected final void verifyFinished(Finished finished, byte[] handshakeHash) throws HandshakeException {
        if (this.masterSecret == null) {
            throw new IllegalStateException("master secret not available!");
        }
        finished.verifyData(this.getSession().getCipherSuite().getThreadLocalPseudoRandomFunctionMac(), this.masterSecret, !this.isClient(), handshakeHash);
    }

    public final boolean hasMasterSecret() {
        return this.masterSecret != null;
    }

    protected final void wrapMessage(DTLSFlight flight, HandshakeMessage handshakeMessage) {
        handshakeMessage.setMessageSeq(this.sendMessageSequence);
        ++this.sendMessageSequence;
        int epoch = this.context.getWriteEpoch();
        if (epoch == 0) {
            this.handshakeMessages.add(handshakeMessage);
        }
        flight.addDtlsMessage(epoch, handshakeMessage);
    }

    protected final void wrapMessage(DTLSFlight flight, ChangeCipherSpecMessage ccsMessage) {
        flight.addDtlsMessage(this.context.getWriteEpoch(), ccsMessage);
    }

    protected GenericHandshakeMessage reassembleFragment(FragmentedHandshakeMessage fragment) throws HandshakeException {
        this.LOGGER.debug("Processing {} message fragment ...", (Object)fragment.getMessageType());
        try {
            if (fragment.getMessageLength() > this.maxFragmentedHandshakeMessageLength) {
                throw new IllegalArgumentException("Fragmented message length exceeded (" + fragment.getMessageLength() + " > " + this.maxFragmentedHandshakeMessageLength + ")!");
            }
            int messageSeq = fragment.getMessageSeq();
            if (this.reassembledMessage == null) {
                this.reassembledMessage = new ReassemblingHandshakeMessage(fragment);
            } else {
                if (this.reassembledMessage.getMessageSeq() != messageSeq) {
                    throw new IllegalArgumentException("Current reassemble message has different seqn " + this.reassembledMessage.getMessageSeq() + " != " + messageSeq);
                }
                this.reassembledMessage.add(fragment);
            }
            if (this.reassembledMessage.isComplete()) {
                ReassemblingHandshakeMessage message = this.reassembledMessage;
                this.LOGGER.debug("Successfully re-assembled {} message", (Object)message.getMessageType());
                this.reassembledMessage = null;
                return message;
            }
        }
        catch (IllegalArgumentException ex) {
            throw new HandshakeException(ex.getMessage(), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.DECODE_ERROR));
        }
        return null;
    }

    protected abstract boolean isClient();

    HandshakeParameter getParameter() {
        DTLSSession session = this.getSession();
        return new HandshakeParameter(session.getKeyExchange(), session.receiveCertificateType());
    }

    public final ServerNames getServerNames() {
        return this.sniEnabled ? this.getSession().getServerNames() : null;
    }

    public final DTLSSession getSession() {
        return this.context.getSession();
    }

    public final DTLSContext getDtlsContext() {
        return this.context;
    }

    public final InetSocketAddress getPeerAddress() {
        return this.peer;
    }

    public final Connection getConnection() {
        return this.connection;
    }

    public DTLSFlight createFlight() {
        return new DTLSFlight(this.context, this.flightNumber, this.getPeerAddress());
    }

    public boolean supportsConnectionId() {
        return ConnectionId.supportsConnectionId(this.connectionIdGenerator);
    }

    public ConnectionId getReadConnectionId() {
        if (ConnectionId.useConnectionId(this.connectionIdGenerator)) {
            return this.connection.getConnectionId();
        }
        if (ConnectionId.supportsConnectionId(this.connectionIdGenerator)) {
            return ConnectionId.EMPTY;
        }
        return null;
    }

    public Random getClientRandom() {
        return this.clientRandom;
    }

    public Random getServerRandom() {
        return this.serverRandom;
    }

    final int getNextReceiveMessageSequenceNumber() {
        return this.nextReceiveMessageSequence;
    }

    public void addApplicationDataForDeferredProcessing(RawData outgoingMessage) {
        if (this.deferredApplicationData.size() < this.maxDeferredProcessedOutgoingApplicationDataMessages) {
            this.deferredApplicationData.add(outgoingMessage);
        }
    }

    public void addRecordsOfNextEpochForDeferredProcessing(Record incomingMessage) {
        this.addDeferredProcessedRecord(incomingMessage, this.nextEpochDeferredRecords);
    }

    private boolean addDeferredProcessedRecord(Record incomingMessage, Collection<Record> collection) {
        int size = incomingMessage.size();
        if (this.deferredIncomingRecordsSize + size < this.maxDeferredProcessedIncomingRecordsSize) {
            this.deferredIncomingRecordsSize += size;
            collection.add(incomingMessage);
            return true;
        }
        this.LOGGER.debug("Dropped incoming record from peer [{}], limit of {} bytes exceeded by {}+{} bytes!", new Object[]{incomingMessage.getPeerAddress(), this.maxDeferredProcessedIncomingRecordsSize, this.deferredIncomingRecordsSize, size});
        this.recordLayer.dropReceivedRecord(incomingMessage);
        return false;
    }

    private void removeDeferredProcessedRecord(Record incomingMessage, Collection<Record> collection) {
        if (collection.remove(incomingMessage)) {
            int size = incomingMessage.size();
            if (this.deferredIncomingRecordsSize < size) {
                this.LOGGER.warn("deferred processed incoming records corrupted for peer [{}]! Removing {} bytes exceeds available {} bytes!", new Object[]{incomingMessage.getPeerAddress(), size, this.deferredIncomingRecordsSize});
                throw new IllegalArgumentException("deferred processing of incoming records corrupted!");
            }
            this.deferredIncomingRecordsSize -= size;
        }
    }

    public List<RawData> takeDeferredApplicationData() {
        ArrayList<RawData> applicationData = new ArrayList<RawData>(this.deferredApplicationData);
        this.deferredApplicationData.clear();
        return applicationData;
    }

    public List<Record> takeDeferredRecordsOfNextEpoch() {
        ArrayList<Record> records = new ArrayList<Record>(this.nextEpochDeferredRecords);
        for (Record record : records) {
            this.removeDeferredProcessedRecord(record, this.nextEpochDeferredRecords);
        }
        if (!this.nextEpochDeferredRecords.isEmpty()) {
            this.LOGGER.warn("{} left deferred records", (Object)this.nextEpochDeferredRecords.size());
            this.nextEpochDeferredRecords.clear();
        }
        return records;
    }

    public void takeDeferredApplicationData(Handshaker replacedHandshaker) {
        this.deferredApplicationData.addAll(replacedHandshaker.takeDeferredApplicationData());
    }

    public void completePendingFlight() {
        this.retransmitFlight = null;
        DTLSFlight flight = this.pendingFlight.get();
        if (flight != null) {
            flight.setResponseCompleted();
        }
    }

    public void sendLastFlight(DTLSFlight flight) {
        this.timeoutLastFlight = this.timer.schedule(new TimeoutCompletedTask(), this.nanosExpireTimeout, TimeUnit.NANOSECONDS);
        flight.setRetransmissionNeeded(false);
        this.sendFlight(flight);
    }

    public void sendFlight(DTLSFlight flight) {
        this.completePendingFlight();
        try {
            int effectiveMessageSize;
            int timeout = this.retransmissionTimeout;
            float noise = this.retransmissionRandomFactor - 1.0f;
            if ((double)noise > 0.0) {
                timeout += RandomManager.currentRandom().nextInt(Math.round((float)timeout * noise));
            }
            if (this.eccExpected) {
                timeout += this.additionalTimeoutForEcc;
                this.eccExpected = false;
            }
            timeout = Math.min(timeout, this.maxRetransmissionTimeout);
            flight.setTimeout(timeout);
            this.flightSendNanos = ClockUtil.nanoRealtime();
            this.nanosExpireTime = this.nanosExpireTimeout + this.flightSendNanos;
            int maxDatagramSize = this.recordLayer.getMaxDatagramSize(this.ipv6);
            int maxFragmentSize = this.getSession().getEffectiveFragmentLimit();
            List<DatagramPacket> datagrams = flight.getDatagrams(maxDatagramSize, maxFragmentSize, this.useMultiHandshakeMessagesRecord, this.useMultiRecordMessages, false);
            this.LOGGER.trace("Sending flight of {} message(s) to peer [{}] using {} datagram(s) of max. {} bytes and {} ms timeout.", new Object[]{flight.getNumberOfMessages(), this.peerToLog, datagrams.size(), maxDatagramSize, timeout});
            this.recordLayer.sendFlight(datagrams);
            this.pendingFlight.set(flight);
            if (flight.isRetransmissionNeeded()) {
                this.retransmitFlight = new TimeoutPeerTask(flight);
                flight.scheduleRetransmission(this.timer, this.retransmitFlight);
            }
            if ((effectiveMessageSize = flight.getEffectiveMaxMessageSize()) > 0) {
                this.context.setEffectiveMaxMessageSize(effectiveMessageSize);
            }
        }
        catch (HandshakeException e) {
            this.handshakeFailed(new Exception("handshake flight " + flight.getFlightNumber() + " failed!", e));
        }
        catch (IOException e) {
            this.handshakeFailed(new Exception("handshake flight " + flight.getFlightNumber() + " failed!", e));
        }
    }

    private void handleTimeout(DTLSFlight flight) {
        Handshaker handshaker;
        if (!flight.isResponseCompleted() && null != (handshaker = this.connection.getOngoingHandshake())) {
            if (!handshaker.isProbing() && this.connection.hasEstablishedDtlsContext()) {
                return;
            }
            Exception cause = null;
            String message = "";
            boolean timeout = false;
            if (!this.connection.isExecuting() || !this.recordLayer.isRunning()) {
                message = " Stopped by shutdown!";
            } else {
                int tries = flight.getTries();
                if (tries < this.maxRetransmissions && handshaker.isExpired()) {
                    message = " Stopped by expired realtime!";
                    timeout = true;
                } else if (tries < this.maxRetransmissions) {
                    if (this.useEarlyStopRetransmission && flight.isResponseStarted()) {
                        while (tries < this.maxRetransmissions) {
                            ++tries;
                            flight.incrementTries();
                            flight.incrementTimeout(this.retransmissionTimeoutScale, this.maxRetransmissionTimeout);
                        }
                        flight.incrementTries();
                        this.LOGGER.trace("schedule handshake timeout {}ms after flight {}", (Object)flight.getTimeout(), (Object)flight.getFlightNumber());
                        Runnable retransmit = this.retransmitFlight;
                        if (retransmit != null) {
                            flight.scheduleRetransmission(this.timer, retransmit);
                        }
                        return;
                    }
                    this.LOGGER.trace("Re-transmitting flight for [{}], [{}] retransmissions left", this.peerToLog, (Object)(this.maxRetransmissions - tries - 1));
                    try {
                        flight.incrementTries();
                        flight.incrementTimeout(this.retransmissionTimeoutScale, this.maxRetransmissionTimeout);
                        int maxDatagramSize = this.recordLayer.getMaxDatagramSize(this.ipv6);
                        int maxFragmentSize = this.getSession().getEffectiveFragmentLimit();
                        boolean backOff = this.backOffRetransmission > 0 && tries + 1 > this.backOffRetransmission;
                        List<DatagramPacket> datagrams = flight.getDatagrams(maxDatagramSize, maxFragmentSize, this.useMultiHandshakeMessagesRecord, this.useMultiRecordMessages, backOff);
                        this.LOGGER.debug("Resending flight {} of {} message(s) to peer [{}] using {} datagram(s) of max. {} bytes. Retransmission {} of {}.", new Object[]{flight.getFlightNumber(), flight.getNumberOfMessages(), this.peerToLog, datagrams.size(), maxDatagramSize, tries + 1, this.maxRetransmissions});
                        this.recordLayer.sendFlight(datagrams);
                        Runnable retransmit = this.retransmitFlight;
                        if (retransmit != null) {
                            flight.scheduleRetransmission(this.timer, retransmit);
                        }
                        handshaker.handshakeFlightRetransmitted(flight.getFlightNumber());
                        return;
                    }
                    catch (IOException e) {
                        cause = e;
                        message = " " + e.getMessage();
                        this.LOGGER.warn("Cannot retransmit flight to peer [{}]", this.peerToLog, (Object)e);
                    }
                    catch (HandshakeException e) {
                        this.LOGGER.warn("Cannot retransmit flight to peer [{}]", this.peerToLog, (Object)e);
                        cause = e;
                        message = " " + e.getMessage();
                    }
                } else if (tries > this.maxRetransmissions) {
                    this.LOGGER.debug("Flight for [{}] has reached timeout, discarding ...", this.peerToLog);
                    message = " Stopped by timeout!";
                    timeout = true;
                } else {
                    this.LOGGER.debug("Flight for [{}] has reached maximum no. [{}] of retransmissions, discarding ...", this.peerToLog, (Object)this.maxRetransmissions);
                    message = " Stopped by timeout after " + this.maxRetransmissions + " retransmissions!";
                    timeout = true;
                }
            }
            this.LOGGER.debug("Flight {} of {} message(s) to peer [{}] failed,{} Retransmission {} of {}.", new Object[]{flight.getFlightNumber(), flight.getNumberOfMessages(), this.peerToLog, message, flight.getTries(), this.maxRetransmissions});
            if (this.hasPendingApiCall()) {
                cause = new HandshakeException("Internal callback timeout!", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR));
            }
            if (cause instanceof HandshakeException) {
                this.recordLayer.processHandshakeException(this.connection, (HandshakeException)cause);
                return;
            }
            if (timeout) {
                handshaker.handshakeFailed(new DtlsHandshakeTimeoutException("Handshake flight " + flight.getFlightNumber() + " failed!" + message, flight.getFlightNumber()));
            } else {
                handshaker.handshakeFailed(new DtlsException("Handshake flight " + flight.getFlightNumber() + " failed!" + message, cause));
            }
        }
    }

    public final void addSessionListener(SessionListener listener) {
        if (listener != null) {
            this.sessionListeners.add(listener);
        }
    }

    public final void removeSessionListener(SessionListener listener) {
        if (listener != null) {
            this.sessionListeners.remove(listener);
        }
    }

    protected final void handshakeStarted() throws HandshakeException {
        this.LOGGER.debug("handshake started {}", (Object)this.connection);
        for (SessionListener sessionListener : this.sessionListeners) {
            sessionListener.handshakeStarted(this);
        }
    }

    protected final void contextEstablished() throws HandshakeException {
        if (!this.contextEstablished) {
            if (this.context.getWriteState().hasValidCipherSuite()) {
                this.LOGGER.debug("dtls context established {}", (Object)this.connection);
                this.amendPeerPrincipal();
                this.contextEstablished = true;
                for (SessionListener sessionListener : this.sessionListeners) {
                    sessionListener.contextEstablished(this, this.context);
                }
            } else {
                this.handshakeFailed(new DtlsException("Failed establishing a incomplete session."));
            }
        }
    }

    public final void handshakeCompleted() {
        if (!this.handshakeCompleted) {
            if (this.timeoutLastFlight != null) {
                this.timeoutLastFlight.cancel(false);
            }
            this.handshakeCompleted = true;
            this.completePendingFlight();
            for (SessionListener sessionListener : this.sessionListeners) {
                sessionListener.handshakeCompleted(this);
            }
            SecretUtil.destroy(this);
            this.LOGGER.debug("handshake completed {}", (Object)this.connection);
        }
    }

    public final void handshakeFailed(Throwable cause) {
        if (this.cause == null) {
            this.cause = cause;
        }
        if (!this.handshakeFailed && this.cause == cause) {
            this.LOGGER.debug("handshake failed {}", (Object)this.connection, (Object)cause);
            this.handshakeFailed = true;
            this.completePendingFlight();
            for (SessionListener sessionListener : this.sessionListeners) {
                sessionListener.handshakeFailed(this, cause);
            }
            SecretUtil.destroy(this.context);
            SecretUtil.destroy(this);
        }
    }

    public final void handshakeAborted(Throwable cause) {
        this.handshakeAborted = true;
        this.handshakeFailed(cause);
    }

    public boolean hasContextEstablished() {
        return this.contextEstablished;
    }

    public boolean isProbing() {
        return false;
    }

    public void resetProbing() {
    }

    public boolean isExpired() {
        return !this.contextEstablished && this.pendingFlight.get() != null && ClockUtil.nanoRealtime() - this.nanosExpireTime > 0L;
    }

    public boolean isPskRequestPending() {
        return this.pskRequestPending;
    }

    public boolean isRemovingConnection() {
        return !this.handshakeAborted && !this.connection.hasEstablishedDtlsContext();
    }

    public Throwable getFailureCause() {
        return this.cause;
    }

    public void setFailureCause(Throwable cause) {
        this.completePendingFlight();
        this.cause = cause;
    }

    public void setGenerateClusterMacKeys(boolean enable) {
        this.generateClusterMacKeys = enable;
    }

    public final void handshakeFlightRetransmitted(int flight) {
        for (SessionListener sessionListener : this.sessionListeners) {
            sessionListener.handshakeFlightRetransmitted(this, flight);
        }
        for (RawData message : this.deferredApplicationData) {
            message.onDtlsRetransmission(flight);
        }
    }

    public final boolean isChangeCipherSpecMessageExpected() {
        return this.changeCipherSuiteMessageExpected;
    }

    protected final void expectChangeCipherSpecMessage() {
        this.changeCipherSuiteMessageExpected = true;
    }

    protected void expectEcc() {
        this.eccExpected = true;
    }

    public void verifyCertificate(CertificateMessage message, boolean verifySubject) throws HandshakeException {
        if (this.certificateVerifier == null) {
            this.LOGGER.debug("Certificate validation failed: no verifier available!");
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNEXPECTED_MESSAGE);
            throw new HandshakeException("Trust is not possible!", alert);
        }
        this.LOGGER.info("Start certificate verification.");
        this.certificateVerificationPending = true;
        this.otherPeersPublicKey = message.getPublicKey();
        CertificateVerificationResult verificationResult = this.certificateVerifier.verifyCertificate(this.connection.getConnectionId(), this.getServerNames(), this.getPeerAddress(), !this.isClient(), verifySubject, this.useTruncatedCertificatePathForVerification, message);
        if (verificationResult != null) {
            this.processCertificateVerificationResult(verificationResult);
        }
    }

    public boolean requestCertificateIdentity(List<X500Principal> issuers, ServerNames serverNames, List<CipherSuite.CertificateKeyAlgorithm> certificateKeyAlgorithms, List<SignatureAndHashAlgorithm> signatureAndHashAlgorithms, List<XECDHECryptography.SupportedGroup> curves) throws HandshakeException {
        CertificateIdentityResult result;
        this.certificateIdentityPending = true;
        if (this.certificateIdentityProvider == null) {
            result = new CertificateIdentityResult(this.connection.getConnectionId(), null);
        } else {
            this.LOGGER.info("Start certificate identity.");
            result = this.certificateIdentityProvider.requestCertificateIdentity(this.connection.getConnectionId(), this.isClient(), issuers, serverNames, certificateKeyAlgorithms, signatureAndHashAlgorithms, curves);
        }
        if (result != null) {
            this.processCertificateIdentityResult(result);
            return false;
        }
        return true;
    }

    @Override
    public void destroy() throws DestroyFailedException {
        SecretUtil.destroy(this.otherSecret);
        this.otherSecret = null;
        SecretUtil.destroy(this.masterSecret);
        this.masterSecret = null;
        SecretUtil.destroy(this.clientWriteKey);
        this.clientWriteKey = null;
        SecretUtil.destroy(this.clientWriteMACKey);
        this.clientWriteMACKey = null;
        SecretUtil.destroy(this.clientWriteIV);
        this.clientWriteIV = null;
        SecretUtil.destroy(this.serverWriteKey);
        this.serverWriteKey = null;
        SecretUtil.destroy(this.serverWriteMACKey);
        this.serverWriteMACKey = null;
        SecretUtil.destroy(this.serverWriteIV);
        this.serverWriteIV = null;
        this.destroyed = true;
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    protected void ensureUndestroyed() {
        if (this.destroyed) {
            if (this.handshakeFailed) {
                throw new IllegalStateException("secrets destroyed after failure!", this.cause);
            }
            if (this.contextEstablished) {
                throw new IllegalStateException("secrets destroyed after success!");
            }
            throw new IllegalStateException("secrets destroyed ???");
        }
    }

    private void amendPeerPrincipal() {
        DTLSSession session = this.getSession();
        Principal peerIdentity = session.getPeerIdentity();
        if (peerIdentity instanceof ExtensiblePrincipal) {
            ExtensiblePrincipal extensibleClientIdentity = (ExtensiblePrincipal)peerIdentity;
            AdditionalInfo additionalInfo = this.getAdditionalPeerInfo(peerIdentity);
            if (additionalInfo != null) {
                session.setPeerIdentity(extensibleClientIdentity.amend(additionalInfo));
            }
        }
    }

    private AdditionalInfo getAdditionalPeerInfo(Principal peerIdentity) {
        if (this.applicationLevelInfoSupplier == null || peerIdentity == null) {
            return null;
        }
        return this.applicationLevelInfoSupplier.getInfo(peerIdentity, this.customArgument);
    }

    private class TimeoutCompletedTask
    extends ConnectionTask {
        private TimeoutCompletedTask() {
            super(new Runnable(){

                @Override
                public void run() {
                    if (Handshaker.this.recordLayer.isRunning()) {
                        Handshaker.this.handshakeCompleted();
                    }
                }
            }, false);
        }
    }

    private class TimeoutPeerTask
    extends ConnectionTask {
        private TimeoutPeerTask(final DTLSFlight flight) {
            super(new Runnable(){

                @Override
                public void run() {
                    Handshaker.this.handleTimeout(flight);
                }
            }, true);
        }
    }

    private class ConnectionTask
    implements Runnable {
        private final Runnable task;
        private final boolean force;

        private ConnectionTask(Runnable task, boolean force) {
            this.task = task;
            this.force = force;
        }

        @Override
        public void run() {
            block2: {
                SerialExecutor serialExecutor = Handshaker.this.connection.getExecutor();
                try {
                    serialExecutor.execute(this.task);
                }
                catch (RejectedExecutionException e) {
                    Handshaker.this.LOGGER.debug("Execution rejected while execute task of peer: {}", (Object)Handshaker.this.connection.getPeerAddress(), (Object)e);
                    if (!this.force) break block2;
                    this.task.run();
                }
            }
        }
    }

    private class InboundMessageBuffer {
        private Record changeCipherSpec = null;
        private SortedSet<Record> queue = new TreeSet<Record>(new Comparator<Record>(){

            @Override
            public int compare(Record r1, Record r2) {
                return Handshaker.compareRecords(r1, r2);
            }
        });

        private InboundMessageBuffer() {
        }

        boolean isEmpty() {
            return this.queue.isEmpty();
        }

        Record getNextRecord() {
            Record record;
            int messageSeq;
            if (Handshaker.this.isChangeCipherSpecMessageExpected() && this.changeCipherSpec != null) {
                Record result = this.changeCipherSpec;
                this.changeCipherSpec = null;
                return result;
            }
            while (!this.queue.isEmpty() && (messageSeq = ((HandshakeMessage)(record = this.queue.first()).getFragment()).getMessageSeq()) <= Handshaker.this.nextReceiveMessageSequence) {
                Handshaker.this.removeDeferredProcessedRecord(record, this.queue);
                if (messageSeq != Handshaker.this.nextReceiveMessageSequence) continue;
                return record;
            }
            return null;
        }

        Record getNextRecord(Record candidate) {
            int contextEpoch;
            int recordEpoch = candidate.getEpoch();
            if (recordEpoch == (contextEpoch = Handshaker.this.context.getReadEpoch())) {
                DTLSMessage fragment = candidate.getFragment();
                switch (fragment.getContentType()) {
                    case CHANGE_CIPHER_SPEC: {
                        if (Handshaker.this.isChangeCipherSpecMessageExpected()) {
                            return candidate;
                        }
                        if (this.changeCipherSpec == null) {
                            Handshaker.this.LOGGER.debug("Change Cipher Spec is not expected and therefore kept for later processing!");
                            this.changeCipherSpec = candidate;
                            return null;
                        }
                        Handshaker.this.LOGGER.debug("Change Cipher Spec is received again!");
                        return null;
                    }
                    case HANDSHAKE: {
                        HandshakeMessage handshakeMessage = (HandshakeMessage)fragment;
                        int messageSeq = handshakeMessage.getMessageSeq();
                        if (messageSeq == Handshaker.this.nextReceiveMessageSequence) {
                            return candidate;
                        }
                        if (messageSeq > Handshaker.this.nextReceiveMessageSequence) {
                            Handshaker.this.LOGGER.debug("Queued newer {} message from current epoch, message_seq [{}] > next_receive_seq [{}]", new Object[]{handshakeMessage.getMessageType(), messageSeq, Handshaker.this.nextReceiveMessageSequence});
                            Handshaker.this.addDeferredProcessedRecord(candidate, this.queue);
                            return null;
                        }
                        Handshaker.this.LOGGER.debug("Discarding old {} message_seq [{}] < next_receive_seq [{}]", new Object[]{handshakeMessage.getMessageType(), messageSeq, Handshaker.this.nextReceiveMessageSequence});
                        return null;
                    }
                }
                Handshaker.this.LOGGER.info("Cannot process message of type [{}], discarding...", (Object)fragment.getContentType());
                return null;
            }
            throw new IllegalArgumentException("record epoch " + recordEpoch + " doesn't match dtls context " + contextEpoch);
        }
    }
}

