/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.maven.plugins.hugo.utils;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.plugin.logging.Log;
import org.echocat.maven.plugins.hugo.utils.InputStreamLogger;

public final class ProcessLogger {
    @Nonnull
    private final Optional<InputStreamLogger> stdout;
    @Nonnull
    private final Optional<InputStreamLogger> stderr;

    @Nonnull
    public static Builder processLogger() {
        return new Builder();
    }

    private ProcessLogger(@Nonnull Builder builder) {
        String baseName = (String)builder.name.orElseThrow(() -> new NullPointerException("No name provided."));
        Log log = (Log)builder.log.orElseThrow(() -> new NullPointerException("No log provided."));
        Process process = (Process)builder.process.orElseThrow(() -> new NullPointerException("No process provided."));
        this.stdout = builder.stdoutLevel.map(level -> InputStreamLogger.inputStreamLogger().withName(baseName + ".stdout").withLog(log).withLevel((InputStreamLogger.Level)((Object)level)).withStdoutOf(process).build());
        this.stderr = builder.stderrLevel.map(level -> InputStreamLogger.inputStreamLogger().withName(baseName + ".stderr").withLog(log).withLevel((InputStreamLogger.Level)((Object)level)).withStderrOf(process).build());
    }

    public void waitFor() throws InterruptedException {
        if (this.stdout.isPresent()) {
            this.stdout.get().waitFor();
        }
        if (this.stderr.isPresent()) {
            this.stderr.get().waitFor();
        }
    }

    public static final class Builder {
        @Nonnull
        private Optional<String> name = Optional.empty();
        @Nonnull
        private Optional<Log> log = Optional.empty();
        @Nonnull
        private Optional<Process> process = Optional.empty();
        @Nonnull
        private Optional<InputStreamLogger.Level> stdoutLevel = Optional.empty();
        @Nonnull
        private Optional<InputStreamLogger.Level> stderrLevel = Optional.empty();

        @Nonnull
        public Builder withName(@Nonnull String v) {
            this.name = Optional.of(v);
            return this;
        }

        @Nonnull
        public Builder withLog(@Nonnull Log v) {
            this.log = Optional.of(v);
            return this;
        }

        @Nonnull
        public Builder withProcess(@Nonnull Process v) {
            this.process = Optional.of(v);
            return this;
        }

        @Nonnull
        public Builder withStdoutLevel(@Nullable InputStreamLogger.Level v) {
            this.stdoutLevel = Optional.ofNullable(v);
            return this;
        }

        @Nonnull
        public Builder withStderrLevel(@Nullable InputStreamLogger.Level v) {
            this.stderrLevel = Optional.ofNullable(v);
            return this;
        }

        @Nonnull
        public ProcessLogger build() {
            return new ProcessLogger(this);
        }
    }
}

