/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.maven.plugins.hugo.utils;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.plugin.logging.Log;
import org.echocat.maven.plugins.hugo.utils.Strings;

public final class InputStreamLogger {
    @Nonnull
    private final String name;
    @Nonnull
    private final Log log;
    @Nonnull
    private final InputStream input;
    @Nonnull
    private final Level level;
    @Nonnull
    private Optional<Throwable> problem = Optional.empty();
    private boolean running = false;

    @Nonnull
    public static Builder inputStreamLogger() {
        return new Builder();
    }

    private InputStreamLogger(@Nonnull Builder builder) {
        this.name = (String)builder.name.orElseThrow(() -> new NullPointerException("No name provided."));
        this.log = (Log)builder.log.orElseThrow(() -> new NullPointerException("No log provided."));
        this.input = (InputStream)builder.input.orElseThrow(() -> new NullPointerException("No input provided."));
        this.level = builder.level.orElse(Level.info);
    }

    private void start() {
        Thread thread = new Thread(this::run, this.name);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        Optional<Object> problem = Optional.empty();
        InputStreamLogger inputStreamLogger = this;
        synchronized (inputStreamLogger) {
            this.running = true;
        }
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(this.input(), StandardCharsets.UTF_8));
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    this.log(line);
                }
            }
            catch (EOFException eOFException) {
            }
            catch (Throwable e) {
                problem = Optional.of(e);
            }
        }
        finally {
            inputStreamLogger = this;
            synchronized (inputStreamLogger) {
                this.running = false;
                this.problem = problem;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFor() throws InterruptedException {
        InputStreamLogger inputStreamLogger = this;
        synchronized (inputStreamLogger) {
            if (this.running) {
                this.wait();
            }
            this.problem.ifPresent(e -> {
                if (e instanceof Error) {
                    throw (Error)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                if (e instanceof IOException) {
                    throw new UncheckedIOException(e.getMessage(), (IOException)e);
                }
                throw new RuntimeException(e.getMessage(), (Throwable)e);
            });
        }
    }

    private void log(@Nonnull String what) {
        this.level().log(this.log(), Strings.trimTailingWhitespaces(what));
    }

    @Nonnull
    public Log log() {
        return this.log;
    }

    @Nonnull
    private InputStream input() {
        return this.input;
    }

    @Nonnull
    public Level level() {
        return this.level;
    }

    public static enum Level {
        debug(Log::debug),
        info(Log::info),
        warn(Log::warn),
        error(Log::error);

        @Nonnull
        private final BiConsumer<Log, CharSequence> logFunction;

        private Level(BiConsumer<Log, CharSequence> logFunction) {
            this.logFunction = logFunction;
        }

        private void log(@Nonnull Log log, @Nonnull CharSequence what) {
            this.logFunction.accept(log, what);
        }
    }

    public static final class Builder {
        @Nonnull
        private Optional<String> name = Optional.empty();
        @Nonnull
        private Optional<Log> log = Optional.empty();
        @Nonnull
        private Optional<InputStream> input = Optional.empty();
        @Nonnull
        private Optional<Level> level = Optional.empty();

        @Nonnull
        public Builder withName(@Nonnull String v) {
            this.name = Optional.of(v);
            return this;
        }

        @Nonnull
        public Builder withLog(@Nonnull Log v) {
            this.log = Optional.of(v);
            return this;
        }

        @Nonnull
        public Builder withStdoutOf(@Nonnull Process v) {
            Objects.requireNonNull(v);
            return this.withInput(v.getInputStream());
        }

        @Nonnull
        public Builder withStderrOf(@Nonnull Process v) {
            Objects.requireNonNull(v);
            return this.withInput(v.getErrorStream());
        }

        @Nonnull
        public Builder withInput(@Nonnull InputStream v) {
            this.input = Optional.of(v);
            return this;
        }

        @Nonnull
        public Builder withLevel(@Nullable Level v) {
            this.level = Optional.ofNullable(v);
            return this;
        }

        @Nonnull
        public InputStreamLogger build() {
            InputStreamLogger result = new InputStreamLogger(this);
            result.start();
            return result;
        }
    }
}

