/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.maven.plugins.hugo.utils;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.echocat.maven.plugins.hugo.model.Platform;
import org.echocat.maven.plugins.hugo.utils.FileSystems;

public final class HugoDownloader {
    @Nonnull
    private final Log log;
    @Nonnull
    private final Platform platform;

    @Nonnull
    public static Builder hugoDownloader() {
        return new Builder();
    }

    private HugoDownloader(@Nonnull Builder builder) {
        this.log = (Log)builder.log.orElseThrow(() -> new NullPointerException("No log provided."));
        this.platform = (Platform)((Object)builder.platform.orElseThrow(() -> new NullPointerException("No platform provided.")));
    }

    public void download(@Nonnull String version, @Nonnull Path to) throws MojoExecutionException, MojoFailureException {
        URL from = this.platform().packageDownloadUrlFor(version);
        this.log().info((CharSequence)String.format("Downloading hugo %s from %s...", version, from));
        Path packageAsTemporaryFile = this.downloadToTemporaryFile(from);
        FileSystems.createParentsOf(to);
        Path temporaryTo = this.temporaryFor(to);
        this.platform().packaging().extract(to.getFileName().toString(), packageAsTemporaryFile, temporaryTo);
        FileSystems.ensureExecutable(temporaryTo);
        FileSystems.rename(temporaryTo, to);
        this.log().info((CharSequence)String.format("Downloading hugo %s from %s... DONE!", version, from));
    }

    @Nonnull
    Path temporaryFor(@Nonnull Path to) {
        return to.getParent().resolve("~" + to.getFileName());
    }

    @Nonnull
    Path downloadToTemporaryFile(@Nonnull URL from) throws MojoExecutionException {
        Path to = this.newBufferFile();
        try (InputStream is = this.startDownloadOf(from);
             OutputStream fileOutputStream = Files.newOutputStream(to, new OpenOption[0]);){
            int bytesRead;
            byte[] dataBuffer = new byte[4096];
            while ((bytesRead = is.read(dataBuffer, 0, 4096)) != -1) {
                fileOutputStream.write(dataBuffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Cannot download hugo and save it into %s.", to), (Exception)e);
        }
        return to;
    }

    @Nonnull
    Path newBufferFile() throws MojoExecutionException {
        try {
            return Files.createTempFile("hugo-maven-plugin.buffered-download.", "", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot buffered download file.", (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    InputStream startDownloadOf(@Nonnull URL url) throws MojoExecutionException {
        BufferedInputStream bufferedInputStream;
        block6: {
            boolean success = false;
            InputStream urlIs = url.openStream();
            try {
                BufferedInputStream resultIs = new BufferedInputStream(urlIs);
                success = true;
                bufferedInputStream = resultIs;
                if (success) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (!success) {
                        urlIs.close();
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new MojoExecutionException(String.format("Cannot download hugo from %s. [os.name: %s, arch.name: %s]", url, System.getProperty("os.name", "unknown"), System.getProperty("os.arch", "unknown")), (Exception)e);
                }
            }
            urlIs.close();
        }
        return bufferedInputStream;
    }

    @Nonnull
    public Log log() {
        return this.log;
    }

    @Nonnull
    public Platform platform() {
        return this.platform;
    }

    public static final class Builder {
        @Nonnull
        private Optional<Log> log = Optional.empty();
        @Nonnull
        private Optional<Platform> platform = Optional.empty();

        @Nonnull
        public Builder withLog(@Nonnull Log v) {
            this.log = Optional.of(v);
            return this;
        }

        @Nonnull
        public Builder withPlatform(@Nonnull Platform v) {
            this.platform = Optional.of(v);
            return this;
        }

        @Nonnull
        public HugoDownloader build() {
            return new HugoDownloader(this);
        }
    }
}

