/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.maven.plugins.hugo.utils;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.echocat.maven.plugins.hugo.model.Platform;
import org.echocat.maven.plugins.hugo.utils.HugoDownloader;
import org.echocat.maven.plugins.hugo.utils.InputStreamLogger;
import org.echocat.maven.plugins.hugo.utils.ProcessLogger;

public final class Hugo {
    @Nonnull
    private final Log log;
    @Nonnull
    private final Platform platform;
    @Nonnull
    private final String version;
    @Nonnull
    private final Download download;
    private final HugoDownloader downloader;

    @Nonnull
    public static Builder hugo() {
        return new Builder();
    }

    private Hugo(@Nonnull Builder builder) {
        this.log = (Log)builder.log.orElseThrow(() -> new NullPointerException("No log provided."));
        this.platform = (Platform)((Object)builder.platform.orElseThrow(() -> new NullPointerException("No platform provided.")));
        this.version = (String)builder.version.orElseThrow(() -> new NullPointerException("No version provided."));
        this.download = builder.download.orElse(Download.onDemand);
        this.downloader = HugoDownloader.hugoDownloader().withLog(this.log()).withPlatform(this.platform()).build();
    }

    public void execute(@Nonnull List<String> arguments, @Nonnull Path inWorkingDirectory) throws MojoFailureException, MojoExecutionException {
        Process process = this.start(arguments, inWorkingDirectory);
        ProcessLogger processLogger = this.processLoggerFor(process);
        try {
            process.waitFor();
            this.assertNormalExitOf(process);
            processLogger.waitFor();
        }
        catch (InterruptedException e) {
            throw new MojoExecutionException("Was interrupted.", (Exception)e);
        }
    }

    @Nonnull
    private Process start(@Nonnull List<String> arguments, @Nonnull Path inWorkingDirectory) throws MojoFailureException, MojoExecutionException {
        Process process;
        try {
            process = new ProcessBuilder(new String[0]).command(this.toCommand(arguments)).directory(inWorkingDirectory.toFile()).redirectError(ProcessBuilder.Redirect.PIPE).redirectOutput(ProcessBuilder.Redirect.PIPE).start();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot start hugo process.", (Exception)e);
        }
        return process;
    }

    @Nonnull
    List<String> toCommand(@Nonnull List<String> arguments) throws MojoFailureException, MojoExecutionException {
        ArrayList<String> result = new ArrayList<String>(arguments.size() + 1);
        result.add(this.executable().toString());
        result.addAll(arguments);
        return Collections.unmodifiableList(result);
    }

    @Nonnull
    private ProcessLogger processLoggerFor(@Nonnull Process process) {
        return ProcessLogger.processLogger().withProcess(process).withName("hugo").withLog(this.log()).withStderrLevel(InputStreamLogger.Level.error).withStdoutLevel(InputStreamLogger.Level.info).build();
    }

    void assertNormalExitOf(@Nonnull Process process) throws MojoFailureException {
        int value = process.exitValue();
        if (value != 0) {
            throw new MojoFailureException(String.format("Execution of hugo failed with %d. See output above.", value));
        }
    }

    @Nonnull
    Path executable() throws MojoFailureException, MojoExecutionException {
        Path result = this.platform().hugoExecutable(this.version());
        Download download = this.download();
        if (Files.isExecutable(result) && download != Download.always) {
            return result;
        }
        if (download == Download.never) {
            throw new MojoFailureException("hugo is not available but should also never be downloaded.");
        }
        this.downloader.download(this.version(), result);
        return result;
    }

    @Nonnull
    public Log log() {
        return this.log;
    }

    @Nonnull
    public Platform platform() {
        return this.platform;
    }

    @Nonnull
    public String version() {
        return this.version;
    }

    @Nonnull
    public Download download() {
        return this.download;
    }

    public static enum Download {
        never,
        onDemand,
        always;

    }

    public static final class Builder {
        @Nonnull
        private Optional<Log> log = Optional.empty();
        @Nonnull
        private Optional<Platform> platform = Optional.empty();
        @Nonnull
        private Optional<String> version = Optional.empty();
        @Nonnull
        private Optional<Download> download = Optional.empty();

        @Nonnull
        public Builder withLog(@Nonnull Log v) {
            this.log = Optional.of(v);
            return this;
        }

        @Nonnull
        public Builder withPlatform(@Nonnull Platform v) {
            this.platform = Optional.of(v);
            return this;
        }

        @Nonnull
        public Builder withVersion(@Nonnull String v) {
            this.version = Optional.of(v);
            return this;
        }

        @Nonnull
        public Builder withDownload(@Nullable Download v) {
            this.download = Optional.ofNullable(v);
            return this;
        }

        @Nonnull
        public Hugo build() {
            return new Hugo(this);
        }
    }
}

