/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.maven.plugins.hugo.utils;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.MojoExecutionException;

public final class FileSystems {
    public static final Set<PosixFilePermission> EXECUTE_PERMISSIONS = Collections.unmodifiableSet(new HashSet<PosixFilePermission>(Arrays.asList(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_EXECUTE)));

    public static void createParentsOf(@Nonnull Path what) throws MojoExecutionException {
        Objects.requireNonNull(what);
        FileSystems.createDirectories(what.getParent());
    }

    public static void createDirectories(@Nonnull Path what) throws MojoExecutionException {
        Objects.requireNonNull(what);
        try {
            Files.createDirectories(what, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("%s exists but is not a directory.", what), (Exception)e);
        }
    }

    public static void ensureExecutable(@Nonnull Path what) throws MojoExecutionException {
        try {
            Files.setPosixFilePermissions(what, EXECUTE_PERMISSIONS);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Cannot make %s executable.", what), (Exception)e);
        }
    }

    public static void rename(@Nonnull Path what, @Nonnull Path to) throws MojoExecutionException {
        try {
            Files.move(what, to, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Cannot rename %s to %s.", what, to), (Exception)e);
        }
    }

    private FileSystems() {
    }
}

