/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.maven.plugins.hugo.model;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.echocat.maven.plugins.hugo.model.Architecture;
import org.echocat.maven.plugins.hugo.model.Packaging;

public enum Platform {
    linux_x32(Architecture.x32, "Linux-32bit", Packaging.tarGz, false),
    linux_x64(Architecture.x64, "Linux-64bit", Packaging.tarGz, true),
    linux_arm64(Architecture.arm64, "Linux-ARM64", Packaging.tarGz, false),
    macos_x64(Architecture.x64, "macOS-64bit", Packaging.tarGz, true),
    macos_arm64(Architecture.arm64, "macOS-ARM64", Packaging.tarGz, true),
    windows_x32(Architecture.x32, "Windows-32bit", Packaging.zip, false, ".exe"),
    windows_x64(Architecture.x64, "Windows-64bit", Packaging.zip, true, ".exe"),
    windows_arm64(Architecture.arm64, "Windows-ARM", Packaging.zip, false, ".exe");

    private static final Optional<Platform> actual;
    @Nonnull
    private final Architecture architecture;
    @Nonnull
    private final String platformSuffix;
    @Nonnull
    private final Packaging packaging;
    @Nonnull
    private final Optional<String> executableExtension;
    private final boolean extendedSupported;

    @Nonnull
    public static Optional<Platform> tryPlatform() {
        return actual;
    }

    @Nonnull
    public static Platform platform() throws MojoFailureException {
        return Platform.tryPlatform().orElseThrow(() -> new MojoFailureException("Unsupported platform/operating-system/architecture."));
    }

    private Platform(@Nonnull Architecture architecture, String platformSuffix, Packaging packaging, boolean extendedSupported) {
        this(architecture, platformSuffix, packaging, extendedSupported, null);
    }

    private Platform(@Nonnull Architecture architecture, String platformSuffix, @Nullable Packaging packaging, boolean extendedSupported, String executableExtension) {
        this.architecture = architecture;
        this.platformSuffix = platformSuffix;
        this.packaging = packaging;
        this.extendedSupported = extendedSupported;
        this.executableExtension = Optional.ofNullable(executableExtension);
    }

    @Nonnull
    public Architecture architecture() {
        return this.architecture;
    }

    @Nonnull
    public String platformSuffix() {
        return this.platformSuffix;
    }

    @Nonnull
    public Packaging packaging() {
        return this.packaging;
    }

    public boolean extendedSupported() {
        return this.extendedSupported;
    }

    @Nonnull
    public Optional<String> executableExtension() {
        return this.executableExtension;
    }

    @Nonnull
    public Path hugoExecutable(@Nonnull String version) {
        return this.hugoExecutableDirectory(version).resolve(this.hugoExecutableFileName());
    }

    @Nonnull
    private String hugoExecutableFileName() {
        return "hugo" + this.executableExtension().orElse("");
    }

    @Nonnull
    private Path hugoExecutableDirectory(@Nonnull String version) {
        return Platform.tempDirectory().resolve("hugo_cache").resolve("bin").resolve(String.format("%s-%s", new Object[]{this, version}));
    }

    @Nonnull
    private static Path tempDirectory() {
        return Paths.get(System.getProperty("java.io.tmpdir", "var/tmp"), new String[0]);
    }

    @Nonnull
    public URL packageDownloadUrlFor(@Nonnull String version) throws MojoExecutionException {
        try {
            return new URL(String.format("https://github.com/gohugoio/hugo/releases/download/v%s/%s", version, this.downloadFileNameFor(version)));
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException(String.format("Cannot construct valid URL to download hugo in version '%s', for '%s'.", new Object[]{version, this}));
        }
    }

    @Nonnull
    private String downloadFileNameFor(@Nonnull String version) {
        StringBuilder sb = new StringBuilder();
        sb.append("hugo_");
        if (this.extendedSupported()) {
            sb.append("extended_");
        }
        sb.append(version).append("_").append(this.platformSuffix()).append(this.packaging().extension());
        return sb.toString();
    }

    @Nonnull
    private static Optional<Platform> detect() {
        Optional<Architecture> arch = Architecture.findArchitecture();
        if (!arch.isPresent()) {
            return Optional.empty();
        }
        String os = System.getProperty("os.name", "unknown").toLowerCase();
        if (os.startsWith("windows")) {
            return Platform.detectWindows(arch.get());
        }
        if (os.startsWith("linux")) {
            return Platform.detectLinux(arch.get());
        }
        if (os.startsWith("mac")) {
            return Platform.detectMacOs(arch.get());
        }
        return Optional.empty();
    }

    private static Optional<Platform> detectWindows(@Nonnull Architecture arch) {
        switch (arch) {
            case x32: {
                return Optional.of(windows_x32);
            }
            case x64: {
                return Optional.of(windows_x64);
            }
            case arm64: {
                return Optional.of(windows_arm64);
            }
        }
        return Optional.empty();
    }

    private static Optional<Platform> detectLinux(@Nonnull Architecture arch) {
        switch (arch) {
            case x32: {
                return Optional.of(linux_x32);
            }
            case x64: {
                return Optional.of(linux_x64);
            }
            case arm64: {
                return Optional.of(linux_arm64);
            }
        }
        return Optional.empty();
    }

    private static Optional<Platform> detectMacOs(@Nonnull Architecture arch) {
        switch (arch) {
            case x64: {
                return Optional.of(macos_x64);
            }
            case arm64: {
                return Optional.of(macos_arm64);
            }
        }
        return Optional.empty();
    }

    static {
        actual = Platform.detect();
    }
}

