/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.maven.plugins.hugo.model;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nonnull;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public enum Packaging {
    tarGz(".tar.gz"){

        @Override
        protected ArchiveInputStream open(@Nonnull InputStream is) throws IOException {
            return new TarArchiveInputStream((InputStream)new GZIPInputStream(is));
        }
    }
    ,
    zip(".zip"){

        @Override
        protected ArchiveInputStream open(@Nonnull InputStream is) {
            return new ZipArchiveInputStream(is);
        }
    };

    @Nonnull
    private final String extension;

    private Packaging(String extension) {
        this.extension = Objects.requireNonNull(extension);
    }

    @Nonnull
    public String extension() {
        return this.extension;
    }

    protected abstract ArchiveInputStream open(@Nonnull InputStream var1) throws IOException;

    public void extract(@Nonnull String file, @Nonnull Path from, @Nonnull Path to) throws MojoExecutionException, MojoFailureException {
        try (InputStream is = Files.newInputStream(from, new OpenOption[0]);
             ArchiveInputStream archive = this.open(is);){
            ArchiveEntry next = archive.getNextEntry();
            while (next != null) {
                String actualFileName = new File(next.getName()).getName();
                if (!next.isDirectory() && actualFileName.equalsIgnoreCase(file)) {
                    this.copy((InputStream)archive, to);
                    return;
                }
                next = archive.getNextEntry();
            }
            throw new MojoFailureException(String.format("%s does not contain expected file %s.", from, file));
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Cannot extract %s from %s to %s.", from, from, to), (Exception)e);
        }
    }

    private void copy(@Nonnull InputStream is, @Nonnull Path to) throws IOException {
        try (OutputStream os = Files.newOutputStream(to, new OpenOption[0]);){
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
    }
}

