/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.maven.plugins.hugo.model;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.compress.utils.FileNameUtils;
import org.apache.maven.plugin.MojoFailureException;

public final class Config {
    @Nonnull
    private final Type type;
    @Nonnull
    private final Path path;
    @Nonnull
    private final String name;

    @Nonnull
    public static Config configOf(@Nonnull Path path) throws MojoFailureException {
        Objects.requireNonNull(path);
        return new Config(path);
    }

    private Config(@Nonnull Path path) throws MojoFailureException {
        this.path = Objects.requireNonNull(path);
        String fileName = this.path.getFileName().toString();
        if (!Files.exists(this.path, new LinkOption[0])) {
            throw new MojoFailureException(String.format("Configuration %s does not exist.", this.path));
        }
        if (Files.isDirectory(this.path, new LinkOption[0])) {
            this.type = Type.directory;
            this.name = fileName;
        } else if (Files.isRegularFile(this.path, new LinkOption[0])) {
            this.type = Type.file;
            this.name = FileNameUtils.getBaseName((String)fileName);
        } else {
            throw new MojoFailureException(String.format("Configuration %s is neither a directory nor regular file.", this.path));
        }
    }

    @Nonnull
    public Type type() {
        return this.type;
    }

    @Nonnull
    public String parameterName() {
        return this.type().parameterName();
    }

    @Nonnull
    public Path path() {
        return this.path;
    }

    @Nonnull
    public String name() {
        return this.name;
    }

    public String toString() {
        return this.path().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Config that = (Config)o;
        return this.path.equals(that.path);
    }

    public int hashCode() {
        return Objects.hash(this.path);
    }

    public static enum Type {
        file("--config"),
        directory("--configDir");

        @Nonnull
        private final String parameterName;

        private Type(String parameterName) {
            this.parameterName = parameterName;
        }

        @Nonnull
        public String parameterName() {
            return this.parameterName;
        }
    }
}

