/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.maven.plugins.hugo.model;

import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public enum Architecture {
    x64("^(x8664|amd64|ia32e|em64t|x64)$"),
    x32("^(x8632|x86|i[3-6]86|ia32|x32)$"),
    arm32("^(arm|arm32)$"),
    arm64("^(aarch64|arm64)$");

    private final Pattern pattern;

    private Architecture(String regex) {
        this.pattern = Pattern.compile(regex);
    }

    public boolean matchesArchString(@Nonnull String what) {
        String normalizedWhat = Objects.requireNonNull(what).toLowerCase(Locale.US).replaceAll("[^a-z0-9]+", "");
        return this.pattern.matcher(normalizedWhat).matches();
    }

    @Nonnull
    public static Optional<Architecture> findArchitecture() {
        String arch = ArchNameProvider.get();
        return Architecture.findArchitectureMatchesString(arch);
    }

    @Nonnull
    public static Optional<Architecture> findArchitectureMatchesString(@Nonnull String what) {
        return Arrays.stream(Architecture.values()).filter(architecture -> architecture.matchesArchString(what)).findFirst();
    }

    static class ArchNameProvider {
        ArchNameProvider() {
        }

        static String get() {
            return System.getProperty("os.arch", "unknown");
        }
    }
}

