/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.maven.plugins.hugo;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.SelectorUtils;
import org.echocat.maven.plugins.hugo.BaseBuildMojo;
import org.echocat.maven.plugins.hugo.model.Config;
import org.echocat.maven.plugins.hugo.model.ConfigAndOutput;

@Mojo(name="build-multi", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresProject=false)
public class BuildMultiMojo
extends BaseBuildMojo {
    @Parameter(name="configBase", property="hugo.configBase", required=true)
    private File configBase;
    @Parameter(name="configIncludes")
    private List<String> configIncludes;
    @Parameter(name="configExcludes")
    private List<String> configExcludes;
    @Parameter(name="outputBase", property="hugo.outputBase", defaultValue="${project.build.directory}/generated-resources/hugo", required=true)
    private File outputBase;

    public void execute() throws MojoExecutionException, MojoFailureException {
        for (ConfigAndOutput configAndOutput : this.configAndOutputs()) {
            this.log().info((CharSequence)String.format("-- build %s --", configAndOutput.config().name()));
            String targetPath = this.resourcesTargetPath() + "/" + configAndOutput.config().name();
            this.execute(configAndOutput, targetPath);
        }
    }

    @Nonnull
    protected List<ConfigAndOutput> configAndOutputs() throws MojoFailureException, MojoExecutionException {
        List<Config> configs = this.configs();
        ArrayList<ConfigAndOutput> result = new ArrayList<ConfigAndOutput>(configs.size());
        for (Config config : configs) {
            result.add(this.configAndOutputFor(config));
        }
        return Collections.unmodifiableList(result);
    }

    @Nonnull
    protected List<Config> configs() throws MojoFailureException, MojoExecutionException {
        List<Path> paths = this.configPaths();
        ArrayList<Config> result = new ArrayList<Config>(paths.size());
        for (Path path : paths) {
            result.add(Config.configOf(path));
        }
        return Collections.unmodifiableList(result);
    }

    @Nonnull
    protected List<Path> configPaths() throws MojoFailureException, MojoExecutionException {
        List<Path> list;
        block8: {
            Path configBase = this.configBase();
            Stream<Path> candidates = Files.list(configBase);
            try {
                list = Collections.unmodifiableList(candidates.filter(this::allowedConfig).collect(Collectors.toList()));
                if (candidates == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (candidates != null) {
                        try {
                            candidates.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new MojoExecutionException(String.format("Cannot collect potential config paths from %s", configBase));
                }
            }
            candidates.close();
        }
        return list;
    }

    private boolean allowedConfig(@Nonnull Path candidate) {
        String fileName = candidate.getFileName().toString();
        return this.matchesOneOf(fileName, this.configIncludes(), true) && !this.matchesOneOf(fileName, this.configExcludes(), false);
    }

    private boolean matchesOneOf(@Nonnull String str, @Nonnull Collection<String> patterns, boolean def) {
        if (patterns.isEmpty()) {
            return def;
        }
        for (String pattern : patterns) {
            if (!SelectorUtils.match((String)pattern, (String)str)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    protected ConfigAndOutput configAndOutputFor(@Nonnull Config config) throws MojoFailureException {
        return ConfigAndOutput.configAndOutputOf(config, this.outputBase().resolve(config.name()));
    }

    @Nonnull
    protected List<String> configIncludes() {
        return Optional.ofNullable(this.configIncludes).map(ArrayList::new).map(Collections::unmodifiableList).orElseGet(Collections::emptyList);
    }

    @Nonnull
    protected List<String> configExcludes() {
        return Optional.ofNullable(this.configExcludes).map(ArrayList::new).map(Collections::unmodifiableList).orElseGet(Collections::emptyList);
    }

    @Nonnull
    protected Path configBase() throws MojoFailureException {
        return Optional.ofNullable(this.configBase).map(File::toPath).orElseThrow(() -> new MojoFailureException("configBase property missing."));
    }

    @Nonnull
    protected Path outputBase() throws MojoFailureException {
        return Optional.ofNullable(this.outputBase).map(File::toPath).orElseThrow(() -> new MojoFailureException("outputBase property missing."));
    }
}

