/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.maven.plugins.hugo;

import java.io.File;
import java.nio.file.Path;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.echocat.maven.plugins.hugo.BaseBuildMojo;
import org.echocat.maven.plugins.hugo.model.Config;
import org.echocat.maven.plugins.hugo.model.ConfigAndOutput;

@Mojo(name="build", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresProject=false)
public class BuildMojo
extends BaseBuildMojo {
    @Parameter(name="config", property="hugo.config", required=true)
    private File config;
    @Parameter(name="output", property="hugo.output", defaultValue="${project.build.directory}/generated-resources/hugo", required=true)
    private File output;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.execute(this.configAndOutput(), this.resourcesTargetPath());
    }

    @Nonnull
    protected ConfigAndOutput configAndOutput() throws MojoFailureException {
        return ConfigAndOutput.configAndOutputOf(this.config(), this.output());
    }

    @Nonnull
    protected Config config() throws MojoFailureException {
        Path path = Optional.ofNullable(this.config).map(File::toPath).orElseThrow(() -> new MojoFailureException("config property missing."));
        return Config.configOf(path);
    }

    @Nonnull
    protected Path output() throws MojoFailureException {
        return Optional.ofNullable(this.output).map(File::toPath).orElseThrow(() -> new MojoFailureException("output property missing."));
    }
}

