/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.maven.plugins.hugo;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.echocat.maven.plugins.hugo.model.Platform;
import org.echocat.maven.plugins.hugo.utils.Hugo;

public abstract class BaseMojo
extends AbstractMojo {
    private static final String DEFAULT_VERSION = "0.88.1";
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(name="version", property="hugo.version", defaultValue="0.88.1")
    private String version;
    @Parameter(name="download", property="hugo.download", defaultValue="onDemand")
    private Hugo.Download download;
    @Parameter(name="workingDirectory", property="hugo.workingDirectory", defaultValue="${project.basedir}")
    private File workingDirectory;
    @Parameter(name="additionalArguments")
    private List<String> additionalArguments;
    @Parameter(name="outputIncludes")
    private List<String> outputIncludes;
    @Parameter(name="outputExcludes")
    private List<String> outputExcludes;
    @Parameter(name="environment", property="hugo.environment")
    private String environment;

    @Nonnull
    protected Hugo hugo() throws MojoFailureException {
        return Hugo.hugo().withLog(this.log()).withVersion(this.version()).withDownload(this.download()).withPlatform(Platform.platform()).build();
    }

    @Nonnull
    protected Optional<MavenProject> project() {
        return Optional.ofNullable(this.project);
    }

    @Nonnull
    protected Log log() throws MojoFailureException {
        return Optional.ofNullable(this.getLog()).orElseThrow(() -> new MojoFailureException("No log available."));
    }

    @Nonnull
    protected String version() {
        return Optional.ofNullable(this.version).orElse(DEFAULT_VERSION);
    }

    @Nonnull
    protected Hugo.Download download() {
        return Optional.ofNullable(this.download).orElse(Hugo.Download.onDemand);
    }

    @Nonnull
    protected Path workingDirectory() throws MojoFailureException {
        return Optional.ofNullable(this.workingDirectory).map(File::toPath).orElseThrow(() -> new MojoFailureException("workingDirectory property missing."));
    }

    @Nonnull
    protected List<String> arguments(String ... args) {
        return this.arguments(args != null ? Arrays.asList(args) : Collections.emptyList());
    }

    @Nonnull
    protected List<String> arguments(@Nonnull List<String> input) {
        ArrayList<String> result = new ArrayList<String>(input);
        this.environment().ifPresent(v -> {
            result.add("--environment");
            result.add((String)v);
        });
        Optional.ofNullable(this.additionalArguments).ifPresent(result::addAll);
        return Collections.unmodifiableList(result);
    }

    @Nonnull
    protected Resource toOutputResource(@Nonnull Path path, @Nonnull String target) {
        Resource result = new Resource();
        result.setTargetPath(target);
        result.setDirectory(path.toString());
        result.setIncludes(this.outputIncludes);
        result.setExcludes(this.outputExcludes);
        return result;
    }

    @Nonnull
    protected Optional<String> environment() {
        return Optional.ofNullable(this.environment);
    }
}

