/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.maven.plugins.hugo;

import java.nio.file.Path;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.echocat.maven.plugins.hugo.BaseMojo;
import org.echocat.maven.plugins.hugo.model.Config;
import org.echocat.maven.plugins.hugo.model.ConfigAndOutput;

public abstract class BaseBuildMojo
extends BaseMojo {
    @Parameter(name="resourcesTargetPath", defaultValue="public")
    private String resourcesTargetPath;

    protected void execute(@Nonnull ConfigAndOutput configAndOutput, @Nonnull String targetPath) throws MojoExecutionException, MojoFailureException {
        Config config = configAndOutput.config();
        Path output = configAndOutput.output();
        this.hugo().execute(this.arguments(config.parameterName(), config.path().toString(), "--destination", output.toString()), this.workingDirectory());
        this.log().info((CharSequence)"");
        this.project().ifPresent(v -> v.addResource(this.toOutputResource(output, targetPath)));
    }

    @Nonnull
    protected String resourcesTargetPath() {
        return Optional.ofNullable(this.resourcesTargetPath).orElse("target");
    }
}

