/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.doc;

import com.lowagie.text.Document;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEventHelper;
import com.lowagie.text.pdf.PdfWriter;
import java.net.URL;
import org.drools.verifier.doc.DroolsDocsBuilder;
import org.drools.verifier.doc.DroolsDocsComponentFactory;

class EndPage
extends PdfPageEventHelper {
    private final String currentDate;

    public EndPage(String currentDate) {
        this.currentDate = currentDate;
    }

    public void onEndPage(PdfWriter writer, Document document) {
        try {
            Image image = Image.getInstance((URL)DroolsDocsBuilder.class.getResource("guvnor-webapp.png"));
            image.setAlignment(2);
            image.scaleAbsolute(100.0f, 30.0f);
            Rectangle page = document.getPageSize();
            PdfPTable head = new PdfPTable(2);
            PdfPCell cell1 = new PdfPCell(image);
            cell1.setHorizontalAlignment(0);
            cell1.setBorder(0);
            head.addCell(cell1);
            PdfPCell cell2 = new PdfPCell(new Phrase(this.currentDate, DroolsDocsComponentFactory.HEADER_FOOTER_TEXT));
            cell2.setHorizontalAlignment(2);
            cell2.setBorder(0);
            head.addCell(cell2);
            head.setTotalWidth(page.getWidth() - document.leftMargin() - document.rightMargin());
            head.writeSelectedRows(0, -1, document.leftMargin(), page.getHeight() - document.topMargin() + head.getTotalHeight(), writer.getDirectContent());
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }
}

